/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;

public class DefaultBigDecimalMath {
    private static MathContext defaultMathContext = DefaultBigDecimalMath.createDefaultMathContext();

    private static MathContext createDefaultMathContext() {
        int precision = DefaultBigDecimalMath.getIntSystemProperty("ch.obermuhlner.math.big.default.precision", MathContext.DECIMAL128.getPrecision());
        RoundingMode rounding = DefaultBigDecimalMath.getRoundingModeSystemProperty("ch.obermuhlner.math.big.default.rounding", MathContext.DECIMAL128.getRoundingMode());
        return new MathContext(precision, rounding);
    }

    private static int getIntSystemProperty(String propertyKey, int defaultValue) {
        String propertyValue = System.getProperty(propertyKey, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            return DefaultBigDecimalMath.propertyException(propertyKey, propertyValue, defaultValue);
        }
    }

    private static RoundingMode getRoundingModeSystemProperty(String propertyKey, RoundingMode defaultValue) {
        String propertyValue = System.getProperty(propertyKey, defaultValue.name());
        try {
            return RoundingMode.valueOf(propertyValue);
        }
        catch (IllegalArgumentException ex) {
            return DefaultBigDecimalMath.propertyException(propertyKey, propertyValue, defaultValue);
        }
    }

    private static <T> T propertyException(String propertyKey, String propertyValue, T defaultValue) {
        System.err.println("Property '" + propertyKey + "' is not valid: " + propertyValue + " (using " + defaultValue + " instead)");
        return defaultValue;
    }

    public static void setDefaultMathContext(MathContext defaultMathContext) {
        Objects.requireNonNull(defaultMathContext);
        DefaultBigDecimalMath.defaultMathContext = defaultMathContext;
    }

    public static MathContext getDefaultMathContext() {
        return defaultMathContext;
    }

    public static BigDecimal round(BigDecimal value) {
        return BigDecimalMath.round(value, defaultMathContext);
    }

    public static BigDecimal roundWithTrailingZeroes(BigDecimal value) {
        return BigDecimalMath.roundWithTrailingZeroes(value, defaultMathContext);
    }

    public static BigDecimal add(BigDecimal x, BigDecimal y) {
        return x.add(y, defaultMathContext);
    }

    public static BigDecimal subtract(BigDecimal x, BigDecimal y) {
        return x.subtract(y, defaultMathContext);
    }

    public static BigDecimal multiply(BigDecimal x, BigDecimal y) {
        return x.multiply(y, defaultMathContext);
    }

    public static BigDecimal divide(BigDecimal x, BigDecimal y) {
        return x.divide(y, defaultMathContext);
    }

    public static BigDecimal remainder(BigDecimal x, BigDecimal y) {
        return x.remainder(y, defaultMathContext);
    }

    public static BigDecimal reciprocal(BigDecimal x) {
        return BigDecimalMath.reciprocal(x, defaultMathContext);
    }

    public static BigDecimal factorial(BigDecimal x) {
        return BigDecimalMath.factorial(x, defaultMathContext);
    }

    public static BigDecimal gamma(BigDecimal x) {
        return BigDecimalMath.gamma(x, defaultMathContext);
    }

    public static BigDecimal bernoulli(int n) {
        return BigDecimalMath.bernoulli(n, defaultMathContext);
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y) {
        return BigDecimalMath.pow(x, y, defaultMathContext);
    }

    public static BigDecimal pow(BigDecimal x, long y) {
        return BigDecimalMath.pow(x, y, defaultMathContext);
    }

    public static BigDecimal sqrt(BigDecimal x) {
        return BigDecimalMath.sqrt(x, defaultMathContext);
    }

    public static BigDecimal root(BigDecimal x, BigDecimal n) {
        return BigDecimalMath.root(x, n, defaultMathContext);
    }

    public static BigDecimal log(BigDecimal x) {
        return BigDecimalMath.log(x, defaultMathContext);
    }

    public static BigDecimal log2(BigDecimal x) {
        return BigDecimalMath.log2(x, defaultMathContext);
    }

    public static BigDecimal log10(BigDecimal x) {
        return BigDecimalMath.log10(x, defaultMathContext);
    }

    public static BigDecimal pi() {
        return BigDecimalMath.pi(defaultMathContext);
    }

    public static BigDecimal e() {
        return BigDecimalMath.e(defaultMathContext);
    }

    public static BigDecimal exp(BigDecimal x) {
        return BigDecimalMath.exp(x, defaultMathContext);
    }

    public static BigDecimal sin(BigDecimal x) {
        return BigDecimalMath.sin(x, defaultMathContext);
    }

    public static BigDecimal asin(BigDecimal x) {
        return BigDecimalMath.asin(x, defaultMathContext);
    }

    public static BigDecimal cos(BigDecimal x) {
        return BigDecimalMath.cos(x, defaultMathContext);
    }

    public static BigDecimal acos(BigDecimal x) {
        return BigDecimalMath.acos(x, defaultMathContext);
    }

    public static BigDecimal tan(BigDecimal x) {
        return BigDecimalMath.tan(x, defaultMathContext);
    }

    public static BigDecimal atan(BigDecimal x) {
        return BigDecimalMath.atan(x, defaultMathContext);
    }

    public static BigDecimal atan2(BigDecimal y, BigDecimal x) {
        return BigDecimalMath.atan2(y, x, defaultMathContext);
    }

    public static BigDecimal cot(BigDecimal x) {
        return BigDecimalMath.cot(x, defaultMathContext);
    }

    public static BigDecimal acot(BigDecimal x) {
        return BigDecimalMath.acot(x, defaultMathContext);
    }

    public static BigDecimal sinh(BigDecimal x) {
        return BigDecimalMath.sinh(x, defaultMathContext);
    }

    public static BigDecimal cosh(BigDecimal x) {
        return BigDecimalMath.cosh(x, defaultMathContext);
    }

    public static BigDecimal tanh(BigDecimal x) {
        return BigDecimalMath.tanh(x, defaultMathContext);
    }

    public static BigDecimal coth(BigDecimal x) {
        return BigDecimalMath.coth(x, defaultMathContext);
    }

    public static BigDecimal asinh(BigDecimal x) {
        return BigDecimalMath.asinh(x, defaultMathContext);
    }

    public static BigDecimal acosh(BigDecimal x) {
        return BigDecimalMath.acosh(x, defaultMathContext);
    }

    public static BigDecimal atanh(BigDecimal x) {
        return BigDecimalMath.atanh(x, defaultMathContext);
    }

    public static BigDecimal acoth(BigDecimal x) {
        return BigDecimalMath.acoth(x, defaultMathContext);
    }
}

