/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public abstract class SeriesCalculator {
    private boolean calculateInPairs;
    private List<BigRational> factors = new ArrayList<BigRational>();

    protected SeriesCalculator() {
        this(false);
    }

    protected SeriesCalculator(boolean calculateInPairs) {
        this.calculateInPairs = calculateInPairs;
    }

    public BigDecimal calculate(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        PowerIterator powerIterator = this.createPowerIterator(x, mathContext);
        BigDecimal sum = BigDecimal.ZERO;
        int i = 0;
        do {
            BigRational factor = this.getFactor(i);
            BigDecimal xToThePower = powerIterator.getCurrentPower();
            powerIterator.calculateNextPower();
            step = factor.getNumerator().multiply(xToThePower).divide(factor.getDenominator(), mathContext);
            ++i;
            if (this.calculateInPairs) {
                xToThePower = powerIterator.getCurrentPower();
                powerIterator.calculateNextPower();
                factor = this.getFactor(i);
                BigDecimal step2 = factor.getNumerator().multiply(xToThePower).divide(factor.getDenominator(), mathContext);
                step = step.add(step2);
                ++i;
            }
            sum = sum.add(step);
        } while (step.abs().compareTo(acceptableError) > 0);
        return sum.round(mathContext);
    }

    protected abstract PowerIterator createPowerIterator(BigDecimal var1, MathContext var2);

    protected BigRational getFactor(int index) {
        while (this.factors.size() <= index) {
            BigRational factor = this.getCurrentFactor();
            this.factors.add(factor);
            this.calculateNextFactor();
        }
        return this.factors.get(index);
    }

    protected abstract BigRational getCurrentFactor();

    protected abstract void calculateNextFactor();
}

