/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.stream;

import ch.obermuhlner.math.big.BigFloat;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BigFloatStream {
    public static Stream<BigFloat> range(BigFloat startInclusive, BigFloat endExclusive) {
        return BigFloatStream.range(startInclusive, endExclusive, startInclusive.getContext().valueOf(1));
    }

    public static Stream<BigFloat> rangeClosed(BigFloat startInclusive, BigFloat endInclusive) {
        return BigFloatStream.rangeClosed(startInclusive, endInclusive, startInclusive.getContext().valueOf(1));
    }

    public static Stream<BigFloat> range(BigFloat startInclusive, BigFloat endExclusive, BigFloat step) {
        return StreamSupport.stream(new BigFloatSpliterator(startInclusive, endExclusive, step), false);
    }

    public static Stream<BigFloat> rangeClosed(BigFloat startInclusive, BigFloat endInclusive, BigFloat step) {
        return StreamSupport.stream(new BigFloatSpliterator(startInclusive, endInclusive.add(step), step), false);
    }

    private static class BigFloatSpliterator
    extends Spliterators.AbstractSpliterator<BigFloat> {
        private BigFloat value;
        private BigFloat step;
        private long count;

        public BigFloatSpliterator(BigFloat startInclusive, BigFloat step, long count) {
            super(count, 1361);
            this.value = startInclusive;
            this.step = step;
            this.count = count;
        }

        public BigFloatSpliterator(BigFloat startInclusive, BigFloat endExclusive, BigFloat step) {
            this(startInclusive, step, BigFloatSpliterator.estimatedCount(startInclusive, endExclusive, step));
        }

        private static long estimatedCount(BigFloat startInclusive, BigFloat endExclusive, BigFloat step) {
            return endExclusive.subtract(startInclusive).divide(step).toLong();
        }

        @Override
        public boolean tryAdvance(Consumer<? super BigFloat> action) {
            if (this.count == 0L) {
                return false;
            }
            action.accept(this.value);
            this.value = this.value.add(this.step);
            --this.count;
            return true;
        }

        @Override
        public Spliterator<BigFloat> trySplit() {
            long firstHalfCount = this.count / 2L;
            if (firstHalfCount == 0L) {
                return null;
            }
            long secondHalfCount = this.count - firstHalfCount;
            this.count = firstHalfCount;
            BigFloat startSecondHalf = this.value.add(this.step.multiply(firstHalfCount));
            return new BigFloatSpliterator(startSecondHalf, this.step, secondHalfCount);
        }
    }
}

