/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.stream;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BigDecimalStream {
    public static Stream<BigDecimal> range(BigDecimal startInclusive, BigDecimal endExclusive, MathContext mathContext) {
        BigDecimal step = BigDecimal.ONE;
        if (endExclusive.subtract(startInclusive).signum() < 0) {
            step = step.negate();
        }
        return BigDecimalStream.range(startInclusive, endExclusive, step, mathContext);
    }

    public static Stream<BigDecimal> rangeClosed(BigDecimal startInclusive, BigDecimal endInclusive, MathContext mathContext) {
        BigDecimal step = BigDecimal.ONE;
        if (endInclusive.subtract(startInclusive).signum() < 0) {
            step = step.negate();
        }
        return BigDecimalStream.rangeClosed(startInclusive, endInclusive, step, mathContext);
    }

    public static Stream<BigDecimal> range(BigDecimal startInclusive, BigDecimal endExclusive, BigDecimal step, MathContext mathContext) {
        if (step.signum() == 0) {
            throw new IllegalArgumentException("invalid step: 0");
        }
        if (endExclusive.subtract(startInclusive).signum() != step.signum()) {
            return Stream.empty();
        }
        return StreamSupport.stream(new BigDecimalSpliterator(startInclusive, endExclusive, false, step, mathContext), false);
    }

    public static Stream<BigDecimal> rangeClosed(BigDecimal startInclusive, BigDecimal endInclusive, BigDecimal step, MathContext mathContext) {
        if (step.signum() == 0) {
            throw new IllegalArgumentException("invalid step: 0");
        }
        if (endInclusive.subtract(startInclusive).signum() == -step.signum()) {
            return Stream.empty();
        }
        return StreamSupport.stream(new BigDecimalSpliterator(startInclusive, endInclusive, true, step, mathContext), false);
    }

    private static class BigDecimalSpliterator
    extends Spliterators.AbstractSpliterator<BigDecimal> {
        private BigDecimal value;
        private BigDecimal step;
        private long count;
        private MathContext mathContext;

        public BigDecimalSpliterator(BigDecimal startInclusive, BigDecimal step, long count, MathContext mathContext) {
            super(count, 1361);
            this.value = startInclusive;
            this.step = step;
            this.count = count;
            this.mathContext = mathContext;
        }

        public BigDecimalSpliterator(BigDecimal startInclusive, BigDecimal end, boolean inclusive, BigDecimal step, MathContext mathContext) {
            this(startInclusive, step, BigDecimalSpliterator.estimatedCount(startInclusive, end, inclusive, step, mathContext), mathContext);
        }

        private static long estimatedCount(BigDecimal startInclusive, BigDecimal end, boolean inclusive, BigDecimal step, MathContext mathContext) {
            BigDecimal count = end.subtract(startInclusive).divide(step, mathContext);
            long result = count.longValue();
            if (BigDecimalMath.fractionalPart(count).signum() != 0) {
                ++result;
            }
            if (inclusive) {
                ++result;
            }
            return result;
        }

        @Override
        public boolean tryAdvance(Consumer<? super BigDecimal> action) {
            if (this.count == 0L) {
                return false;
            }
            action.accept(this.value);
            this.value = this.value.add(this.step, this.mathContext);
            --this.count;
            return true;
        }

        @Override
        public Spliterator<BigDecimal> trySplit() {
            long firstHalfCount = this.count / 2L;
            if (firstHalfCount == 0L) {
                return null;
            }
            long secondHalfCount = this.count - firstHalfCount;
            this.count = firstHalfCount;
            BigDecimal startSecondHalf = this.value.add(this.step.multiply(new BigDecimal(firstHalfCount), this.mathContext));
            return new BigDecimalSpliterator(startSecondHalf, this.step, secondHalfCount, this.mathContext);
        }
    }
}

