/*
 * Decompiled with CFR 0.152.
 */
package ch.marcus_schulte.hivedoc;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Text;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class HivedocMojo
extends AbstractMavenReport
implements MavenReport {
    private static final String NS_SERVICE = "svc";
    private static final String NS_CONFIG_PONT = "conf";
    private static final String NS_SCHEMA = "sch";
    private static final String NS_CONTRIB = "ctr";
    private static final String NS_IMPL = "impl";
    private static final Map elementNamesToNamespace = new HashMap(){
        {
            this.put("service-point", HivedocMojo.NS_SERVICE);
            this.put("configuration-point", HivedocMojo.NS_CONFIG_PONT);
            this.put("schema", HivedocMojo.NS_SCHEMA);
            this.put("contribution", HivedocMojo.NS_CONTRIB);
            this.put("implementation", HivedocMojo.NS_IMPL);
        }
    };
    private SiteRenderer siteRenderer;
    private File outDir;
    private String reportSubDir;
    private File hiveDocsOutputDir;
    private List resources;
    private String[] extraResources;
    private String javadocDir;

    protected void executeReport(Locale arg0) throws MavenReportException {
        this.getLog().info((CharSequence)"HiveDoc Mojo executing ... ");
        this.hiveDocsOutputDir = new File(this.outDir, this.reportSubDir);
        this.hiveDocsOutputDir.mkdirs();
        this.getSink().body();
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            this.getLog().debug((CharSequence)("Scanning resource " + resource.getDirectory() + ", " + resource.getTargetPath()));
            File rdir = new File(resource.getDirectory());
            this.processHivemodulesIn(rdir);
        }
        if (this.extraResources != null) {
            for (int i = 0; i < this.extraResources.length; ++i) {
                this.getLog().debug((CharSequence)("Scanning resource " + this.extraResources[i]));
                File er = new File(this.extraResources[i]);
                this.processHivemodulesIn(er);
            }
        }
        this.getSink().body_();
        this.getSink().close();
    }

    private void processHivemodulesIn(File dir) {
        File[] hivemodules = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().equals("hivemodule.xml");
            }
        });
        if (hivemodules == null) {
            this.getLog().debug((CharSequence)("No hivemodules found in " + dir));
            return;
        }
        for (int i = 0; i < hivemodules.length; ++i) {
            this.getLog().info((CharSequence)("Hivedoc found " + hivemodules[i]));
            try {
                Document hiveModule = new Builder().build(hivemodules[i]);
                this.writeOutputForModule(hiveModule.getRootElement());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        File[] subdirs = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (int i = 0; i < subdirs.length; ++i) {
            this.processHivemodulesIn(subdirs[i]);
        }
    }

    private void writeOutputForModule(Element module) {
        int i;
        this.getSink().sectionTitle1();
        this.getSink().text("HiveModule " + module.getAttributeValue("id") + " version " + module.getAttributeValue("version"));
        this.getSink().sectionTitle1_();
        this.getSink().section1();
        this.getSink().text("Package ");
        String pkg = module.getAttributeValue("package");
        this.getSink().link(this.linkToJavadoc("package", pkg));
        this.getSink().text(pkg);
        this.getSink().link_();
        this.getSink().paragraph();
        this.directTextChildren(module);
        this.getSink().paragraph_();
        Elements servicePoints = module.getChildElements("service-point");
        Elements configPoints = module.getChildElements("configuration-point");
        Elements schemas = module.getChildElements("schema");
        Elements contribs = module.getChildElements("contribution");
        Elements overrides = module.getChildElements("implementation");
        this.writeSummaries(new Elements[]{servicePoints, configPoints, schemas, contribs, overrides}, new String[]{"Service-Points", "Configuration Points", "Schemas", "Contributions", "Implementations"});
        for (i = 0; i < servicePoints.size(); ++i) {
            this.writeServicePoint(servicePoints.get(i), pkg);
        }
        for (i = 0; i < configPoints.size(); ++i) {
            this.writeConfigPoint(configPoints.get(i));
        }
        for (i = 0; i < schemas.size(); ++i) {
            this.writeSchema(schemas.get(i));
        }
        for (i = 0; i < contribs.size(); ++i) {
            this.writeContribution(contribs.get(i));
        }
        for (i = 0; i < overrides.size(); ++i) {
            this.writeImplementation(overrides.get(i), pkg);
        }
        this.getSink().section1_();
    }

    private void directTextChildren(Element elem) {
        for (int i = 0; i < elem.getChildCount(); ++i) {
            if (!(elem.getChild(i) instanceof Text)) continue;
            this.getSink().text(elem.getChild(i).getValue());
        }
    }

    private void writeConfigPoint(Element cpEl) {
        String id = cpEl.getAttributeValue("id");
        this.writeSubsectionTitle(NS_CONFIG_PONT, "Configuration Point", id);
        this.getSink().section2();
        String occ = cpEl.getAttributeValue("occurs");
        if (occ == null) {
            occ = "unbounded";
        }
        this.getSink().paragraph();
        this.getSink().bold();
        this.getSink().text("Occurrence: ");
        this.getSink().bold_();
        this.getSink().text(occ);
        this.getSink().paragraph_();
        this.getSink().paragraph();
        this.directTextChildren(cpEl);
        this.getSink().paragraph_();
        String sid = cpEl.getAttributeValue("schema-id");
        if (sid != null) {
            this.getSink().text("Schema: ");
            this.linkTo(NS_SCHEMA, sid);
        } else {
            this.writeSchema(cpEl.getFirstChildElement("schema"));
        }
        this.getSink().section2_();
    }

    private void writeContribution(Element cEl) {
        String id = cEl.getAttributeValue("configuration-id");
        this.writeSubsectionTitle(NS_CONTRIB, "Contribution to ", id);
        this.getSink().section2();
        this.getSink().paragraph();
        this.directTextChildren(cEl);
        this.getSink().paragraph_();
        this.getSink().verbatim(true);
        this.getSink().text(cEl.toXML());
        this.getSink().verbatim_();
        this.getSink().section2_();
    }

    private void writeImplementation(Element implEl, String pkg) {
        String id = implEl.getAttributeValue("service-id");
        this.writeSubsectionTitle(NS_IMPL, "Implementation of ", id);
        this.getSink().section2();
        this.getSink().paragraph();
        this.directTextChildren(implEl);
        this.getSink().paragraph_();
        this.writeServiceCreation(implEl, pkg);
        this.getSink().section2_();
    }

    private void writeSchema(Element sEl) {
        String id = sEl.getAttributeValue("id");
        if (id != null) {
            this.writeSubsectionTitle(NS_SCHEMA, "Schema", id);
            this.getSink().section2();
        }
        this.getSink().paragraph();
        this.directTextChildren(sEl);
        this.getSink().paragraph_();
        Elements elems = sEl.getChildElements("element");
        this.writeSchemaElementDefinitions(elems);
        if (id != null) {
            this.getSink().section2_();
        }
    }

    private void writeSchemaElementDefinitions(Elements elems) {
        this.getSink().bold();
        this.getSink().text("Elements");
        this.getSink().bold_();
        this.getSink().lineBreak();
        this.getSink().definitionList();
        for (int i = 0; i < elems.size(); ++i) {
            Element e = elems.get(i);
            this.getSink().definedTerm();
            this.getSink().text(e.getAttributeValue("name"));
            this.getSink().definedTerm_();
            this.getSink().definition();
            this.directTextChildren(e);
            this.writeElementAttributeTable(e.getChildElements("attribute"));
            Elements subElements = e.getChildElements("element");
            if (subElements.size() > 0) {
                this.writeSchemaElementDefinitions(subElements);
            }
            this.getSink().definition_();
        }
        this.getSink().definitionList_();
    }

    private void writeElementAttributeTable(Elements attribs) {
        this.getSink().table();
        this.getSink().tableCaption();
        this.getSink().text("Attributes");
        this.getSink().tableCaption_();
        this.getSink().tableRow();
        this.getSink().tableHeaderCell();
        this.getSink().text("Name");
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.getSink().text("Required");
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.getSink().text("Translator");
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.getSink().text("Description");
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
        for (int i = 0; i < attribs.size(); ++i) {
            Element a = attribs.get(i);
            this.getSink().tableRow();
            this.cell(a.getAttributeValue("name"));
            this.cell(a.getAttributeValue("required"));
            this.cell(a.getAttributeValue("translator"));
            this.getSink().tableCell();
            this.directTextChildren(a);
            this.getSink().tableCell_();
            this.getSink().tableRow_();
        }
        this.getSink().table_();
    }

    private void writeServicePoint(Element spEl, String pkg) {
        String id = spEl.getAttributeValue("id");
        this.writeSubsectionTitle(NS_SERVICE, "Service-Point", id);
        this.getSink().section2();
        String intf = spEl.getAttributeValue("interface");
        if (intf == null) {
            intf = id;
        }
        this.getSink().table();
        this.getSink().tableRow();
        this.cell("Interface:");
        this.getSink().tableCell();
        this.getSink().link(this.linkToJavadoc(intf, pkg));
        this.getSink().text(intf);
        this.getSink().link_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        Attribute ps = spEl.getAttribute("parameters-schema-id");
        if (ps != null) {
            this.getSink().tableRow();
            this.cell("Factory-Parameters");
            this.getSink().tableCell();
            this.linkTo(NS_SCHEMA, ps.getValue());
            this.getSink().text(" (" + spEl.getAttributeValue("parameters-occurs") + ")");
            this.getSink().tableCell_();
            this.getSink().tableRow_();
        }
        this.getSink().tableRow();
        this.cell("Creation:");
        this.getSink().tableCell();
        this.writeServiceCreation(spEl, pkg);
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().table_();
        this.getSink().paragraph();
        this.directTextChildren(spEl);
        this.getSink().paragraph_();
        this.getSink().section2_();
    }

    private void writeServiceCreation(Element parent, String pkg) {
        this.writeServiceCreationViaFactory(parent, pkg);
        this.writeDirectServiceCreation(parent, pkg);
        Element interceptor = parent.getFirstChildElement("interceptor");
        if (interceptor != null) {
            this.getSink().text("Intercepted by ");
            this.linkTo(NS_SERVICE, interceptor.getAttributeValue("service-id"));
        }
    }

    private void writeDirectServiceCreation(Element parent, String pkg) {
        Element instance = parent.getFirstChildElement("create-instance");
        if (instance != null) {
            String model = instance.getAttributeValue("model");
            if (model == null) {
                model = "singleton";
            }
            this.getSink().table();
            this.getSink().tableRow();
            this.cell("Service-Model");
            this.cell(model);
            this.getSink().tableRow_();
            this.getSink().tableRow();
            this.cell("Implementation-Class");
            this.getSink().tableCell();
            String implClass = instance.getAttributeValue("class");
            this.getSink().link(this.linkToJavadoc(implClass, pkg));
            this.getSink().text(implClass);
            this.getSink().link_();
            this.getSink().tableCell_();
            this.getSink().tableRow_();
            this.getSink().table_();
        }
    }

    private void writeServiceCreationViaFactory(Element parent, String pkg) {
        Element invocation = parent.getFirstChildElement("invoke-factory");
        if (invocation != null) {
            String model;
            String id = invocation.getAttributeValue("service-id");
            if (id == null) {
                id = "hivemind.BuilderFactory";
            }
            if ((model = invocation.getAttributeValue("model")) == null) {
                model = "singleton";
            }
            String implClass = "";
            String parameters = "";
            if (invocation.getChildElements().size() > 0) {
                if (id.equals("hivemind.BuilderFactory")) {
                    Element construct = invocation.getFirstChildElement("construct");
                    implClass = construct.getAttributeValue("class");
                    for (int i = 0; i < construct.getChildElements().size(); ++i) {
                        parameters = parameters + construct.getChildElements().get(i).toXML() + "\n";
                    }
                } else {
                    parameters = invocation.getChildElements().get(0).toXML();
                }
            }
            this.getSink().table();
            this.getSink().tableRow();
            this.cell("Factory-Service");
            this.getSink().tableCell();
            this.linkTo(NS_SERVICE, id);
            this.getSink().tableCell_();
            this.getSink().tableRow_();
            this.getSink().tableRow();
            this.cell("Service-Model");
            this.cell(model);
            this.getSink().tableRow_();
            this.getSink().tableRow();
            this.cell("Implementation-Class");
            this.getSink().tableCell();
            this.getSink().link(this.linkToJavadoc(implClass, pkg));
            this.getSink().text(implClass);
            this.getSink().link_();
            this.getSink().tableCell_();
            this.getSink().tableRow_();
            if (parameters.length() > 0) {
                this.getSink().tableRow();
                this.cell("Parameters");
                this.getSink().tableCell();
                this.getSink().verbatim(false);
                this.getSink().text(parameters);
                this.getSink().verbatim_();
                this.getSink().tableCell_();
                this.getSink().tableRow_();
            }
            this.getSink().table_();
        }
    }

    private void writeSubsectionTitle(String namespace, String category, String id) {
        this.getSink().sectionTitle2();
        this.getSink().anchor(namespace + "." + id);
        this.getSink().text(category + " " + id);
        this.getSink().anchor_();
        this.getSink().sectionTitle2_();
    }

    private void linkTo(String namespace, String id) {
        this.getSink().link("#" + namespace + "." + id);
        this.getSink().text(id);
        this.getSink().link_();
    }

    private void writeSummaries(Elements[] els, String[] captions) {
        this.getSink().table();
        this.getSink().tableCaption();
        this.getSink().text("Module Summary");
        this.getSink().tableCaption_();
        this.getSink().tableRow();
        for (int i = 0; i < captions.length; ++i) {
            this.getSink().tableHeaderCell();
            this.getSink().text(captions[i]);
            this.getSink().tableHeaderCell_();
        }
        this.getSink().tableRow_();
        boolean rowsLeft = true;
        int row = 0;
        while (rowsLeft) {
            rowsLeft = false;
            this.getSink().tableRow();
            for (int i = 0; i < els.length; ++i) {
                this.getSink().tableCell();
                if (els[i].size() > row) {
                    Element e = els[i].get(row);
                    String id = e.getAttributeValue("id");
                    if (id == null) {
                        id = e.getAttributeValue("service-id");
                    }
                    if (id == null) {
                        id = e.getAttributeValue("configuration-id");
                    }
                    this.linkTo((String)elementNamesToNamespace.get(e.getLocalName()), id);
                    if (els[i].size() > row + 1) {
                        rowsLeft = true;
                    }
                }
                this.getSink().tableCell_();
            }
            this.getSink().tableRow_();
            ++row;
        }
        this.getSink().table_();
    }

    private void cell(String s) {
        this.getSink().tableCell();
        this.getSink().text(s == null ? "" : s);
        this.getSink().tableCell_();
    }

    private String linkToJavadoc(String target, String pkg) {
        if (target.split("\\.").length < 3) {
            target = pkg + "." + target;
        }
        return "../" + this.javadocDir + "/" + target.replace('.', '/') + ".html";
    }

    protected String getOutputDirectory() {
        return this.reportSubDir;
    }

    protected MavenProject getProject() {
        return null;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale arg0) {
        return "Documentation from HiveMind descriptors";
    }

    public String getName(Locale arg0) {
        return "HiveDocs";
    }

    public String getOutputName() {
        return this.reportSubDir + "/index";
    }
}

