/*
 * Decompiled with CFR 0.152.
 */
package ch.ielse.view.imagewatcher;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import java.util.ArrayList;

public class MaterialProgressView
extends View {
    private MaterialProgressDrawable mDrawable;
    private float mScale = 1.0f;

    public MaterialProgressView(Context context) {
        super(context);
        this.initView();
    }

    public MaterialProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.mDrawable = new MaterialProgressDrawable(this.getContext(), this);
        this.mDrawable.setAlpha(255);
        this.mDrawable.setCallback((Drawable.Callback)this);
    }

    public void invalidateDrawable(Drawable dr) {
        if (dr == this.mDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    public void start() {
        this.mDrawable.start();
    }

    public void stop() {
        this.mDrawable.stop();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.mDrawable.getIntrinsicHeight() + this.getPaddingTop() + this.getPaddingBottom();
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int size = this.mDrawable.getIntrinsicHeight();
        this.mDrawable.setBounds(0, 0, size, size);
    }

    protected void onDraw(Canvas canvas) {
        int saveCount = canvas.save();
        Rect rect = this.mDrawable.getBounds();
        int l = this.getPaddingLeft() + (this.getMeasuredWidth() - this.mDrawable.getIntrinsicWidth()) / 2;
        canvas.translate((float)l, (float)this.getPaddingTop());
        canvas.scale(this.mScale, this.mScale, rect.exactCenterX(), rect.exactCenterY());
        this.mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public static class MaterialProgressDrawable
    extends Drawable
    implements Animatable {
        private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
        private static final Interpolator END_CURVE_INTERPOLATOR = new EndCurveInterpolator();
        private static final Interpolator START_CURVE_INTERPOLATOR = new StartCurveInterpolator();
        private static final Interpolator EASE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
        private static final int CIRCLE_DIAMETER = 30;
        private static final float CENTER_RADIUS = 8.0f;
        private static final float STROKE_WIDTH = 2.0f;
        private static final int ANIMATION_DURATION = 1333;
        private static final float NUM_POINTS = 5.0f;
        private static final float MAX_PROGRESS_ARC = 0.8f;
        private final int[] COLORS = new int[]{-1, -1, -1, -1};
        private final ArrayList<Animation> mAnimators = new ArrayList();
        private final Ring mRing;
        private final Drawable.Callback mCallback = new Drawable.Callback(){

            public void invalidateDrawable(Drawable d) {
                MaterialProgressDrawable.this.invalidateSelf();
            }

            public void scheduleDrawable(Drawable d, Runnable what, long when) {
                MaterialProgressDrawable.this.scheduleSelf(what, when);
            }

            public void unscheduleDrawable(Drawable d, Runnable what) {
                MaterialProgressDrawable.this.unscheduleSelf(what);
            }
        };
        private float mRotation;
        private Resources mResources;
        private View mParent;
        private Animation mAnimation;
        private float mRotationCount;
        private double mWidth;
        private double mHeight;
        private Animation mFinishAnimation;

        public MaterialProgressDrawable(Context context, View parent) {
            this.mParent = parent;
            this.mResources = context.getResources();
            this.mRing = new Ring(this.mCallback);
            this.mRing.setColors(this.COLORS);
            this.setSizeParameters(30.0, 30.0, 8.0, 2.0);
            this.setupAnimators();
        }

        private void setSizeParameters(double progressCircleWidth, double progressCircleHeight, double centerRadius, double strokeWidth) {
            Ring ring = this.mRing;
            DisplayMetrics metrics = this.mResources.getDisplayMetrics();
            float screenDensity = metrics.density;
            this.mWidth = progressCircleWidth * (double)screenDensity;
            this.mHeight = progressCircleHeight * (double)screenDensity;
            ring.setStrokeWidth((float)strokeWidth * screenDensity);
            ring.setCenterRadius(centerRadius * (double)screenDensity);
            ring.setColorIndex(0);
            ring.setInsets((int)this.mWidth, (int)this.mHeight);
        }

        public int getIntrinsicHeight() {
            return (int)this.mHeight;
        }

        public int getIntrinsicWidth() {
            return (int)this.mWidth;
        }

        public void draw(Canvas c) {
            Rect bounds = this.getBounds();
            int saveCount = c.save();
            c.rotate(this.mRotation, bounds.exactCenterX(), bounds.exactCenterY());
            this.mRing.draw(c, bounds);
            c.restoreToCount(saveCount);
        }

        public int getAlpha() {
            return this.mRing.getAlpha();
        }

        public void setAlpha(int alpha) {
            this.mRing.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mRing.setColorFilter(colorFilter);
        }

        void setRotation(float rotation) {
            this.mRotation = rotation;
            this.invalidateSelf();
        }

        public int getOpacity() {
            return -3;
        }

        public boolean isRunning() {
            ArrayList<Animation> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                Animation animator = animators.get(i);
                if (!animator.hasStarted() || animator.hasEnded()) continue;
                return true;
            }
            return false;
        }

        public void start() {
            this.mAnimation.reset();
            this.mRing.storeOriginals();
            if (this.mRing.getEndTrim() != this.mRing.getStartTrim()) {
                this.mParent.startAnimation(this.mFinishAnimation);
            } else {
                this.mRing.setColorIndex(0);
                this.mRing.resetOriginals();
                this.mParent.startAnimation(this.mAnimation);
            }
        }

        public void stop() {
            this.mParent.clearAnimation();
            this.setRotation(0.0f);
            this.mRing.setShowArrow(false);
            this.mRing.setColorIndex(0);
            this.mRing.resetOriginals();
        }

        private void setupAnimators() {
            final Ring ring = this.mRing;
            Animation finishRingAnimation = new Animation(){

                public void applyTransformation(float interpolatedTime, Transformation t) {
                    float targetRotation = (float)(Math.floor(ring.getStartingRotation() / 0.8f) + 1.0);
                    float startTrim = ring.getStartingStartTrim() + (ring.getStartingEndTrim() - ring.getStartingStartTrim()) * interpolatedTime;
                    ring.setStartTrim(startTrim);
                    float rotation = ring.getStartingRotation() + (targetRotation - ring.getStartingRotation()) * interpolatedTime;
                    ring.setRotation(rotation);
                    ring.setArrowScale(1.0f - interpolatedTime);
                }
            };
            finishRingAnimation.setInterpolator(EASE_INTERPOLATOR);
            finishRingAnimation.setDuration(666L);
            finishRingAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ring.goToNextColor();
                    ring.storeOriginals();
                    ring.setShowArrow(false);
                    MaterialProgressDrawable.this.mParent.startAnimation(MaterialProgressDrawable.this.mAnimation);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            Animation animation = new Animation(){

                public void applyTransformation(float interpolatedTime, Transformation t) {
                    float minProgressArc = (float)Math.toRadians((double)ring.getStrokeWidth() / (Math.PI * 2 * ring.getCenterRadius()));
                    float startingEndTrim = ring.getStartingEndTrim();
                    float startingTrim = ring.getStartingStartTrim();
                    float startingRotation = ring.getStartingRotation();
                    float minArc = 0.8f - minProgressArc;
                    float endTrim = startingEndTrim + minArc * START_CURVE_INTERPOLATOR.getInterpolation(interpolatedTime);
                    ring.setEndTrim(endTrim);
                    float startTrim = startingTrim + 0.8f * END_CURVE_INTERPOLATOR.getInterpolation(interpolatedTime);
                    ring.setStartTrim(startTrim);
                    float rotation = startingRotation + 0.25f * interpolatedTime;
                    ring.setRotation(rotation);
                    float groupRotation = 144.0f * interpolatedTime + 720.0f * (MaterialProgressDrawable.this.mRotationCount / 5.0f);
                    MaterialProgressDrawable.this.setRotation(groupRotation);
                }
            };
            animation.setRepeatCount(-1);
            animation.setRepeatMode(1);
            animation.setInterpolator(LINEAR_INTERPOLATOR);
            animation.setDuration(1333L);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    MaterialProgressDrawable.this.mRotationCount = 0.0f;
                }

                public void onAnimationEnd(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                    ring.storeOriginals();
                    ring.goToNextColor();
                    ring.setStartTrim(ring.getEndTrim());
                    MaterialProgressDrawable.this.mRotationCount = (MaterialProgressDrawable.this.mRotationCount + 1.0f) % 5.0f;
                }
            });
            this.mFinishAnimation = finishRingAnimation;
            this.mAnimation = animation;
        }

        private static class StartCurveInterpolator
        extends AccelerateDecelerateInterpolator {
            private StartCurveInterpolator() {
            }

            public float getInterpolation(float input) {
                return super.getInterpolation(Math.min(1.0f, input * 2.0f));
            }
        }

        private static class EndCurveInterpolator
        extends AccelerateDecelerateInterpolator {
            private EndCurveInterpolator() {
            }

            public float getInterpolation(float input) {
                return super.getInterpolation(Math.max(0.0f, (input - 0.5f) * 2.0f));
            }
        }

        private static class Ring {
            private final RectF mTempBounds = new RectF();
            private final Paint mArcPaint = new Paint();
            private final Paint mArrowPaint = new Paint();
            private final Drawable.Callback mRingCallback;
            private final Paint mCirclePaint = new Paint();
            private float mStartTrim = 0.0f;
            private float mEndTrim = 0.0f;
            private float mRotation = 0.0f;
            private float mStrokeWidth = 5.0f;
            private float mStrokeInset = 2.5f;
            private int[] mColors;
            private int mColorIndex;
            private float mStartingStartTrim;
            private float mStartingEndTrim;
            private float mStartingRotation;
            private boolean mShowArrow;
            private float mArrowScale;
            private double mRingCenterRadius;
            private int mAlpha;

            public Ring(Drawable.Callback callback) {
                this.mRingCallback = callback;
                this.mArcPaint.setStrokeCap(Paint.Cap.SQUARE);
                this.mArcPaint.setAntiAlias(true);
                this.mArcPaint.setStyle(Paint.Style.STROKE);
                this.mArrowPaint.setStyle(Paint.Style.FILL);
                this.mArrowPaint.setAntiAlias(true);
                this.mCirclePaint.setAntiAlias(true);
            }

            public void draw(Canvas c, Rect bounds) {
                RectF arcBounds = this.mTempBounds;
                arcBounds.set(bounds);
                arcBounds.inset(this.mStrokeInset, this.mStrokeInset);
                float startAngle = (this.mStartTrim + this.mRotation) * 360.0f;
                float endAngle = (this.mEndTrim + this.mRotation) * 360.0f;
                float sweepAngle = endAngle - startAngle;
                this.mArcPaint.setColor(this.mColors[this.mColorIndex]);
                this.mArcPaint.setAlpha(this.mAlpha);
                c.drawArc(arcBounds, startAngle, sweepAngle, false, this.mArcPaint);
            }

            public void setColors(int[] colors) {
                this.mColors = colors;
                this.setColorIndex(0);
            }

            public void setColorIndex(int index) {
                this.mColorIndex = index;
            }

            public void goToNextColor() {
                this.mColorIndex = (this.mColorIndex + 1) % this.mColors.length;
            }

            public void setColorFilter(ColorFilter filter) {
                this.mArcPaint.setColorFilter(filter);
                this.invalidateSelf();
            }

            public int getAlpha() {
                return this.mAlpha;
            }

            public void setAlpha(int alpha) {
                this.mAlpha = alpha;
            }

            public float getStrokeWidth() {
                return this.mStrokeWidth;
            }

            public void setStrokeWidth(float strokeWidth) {
                this.mStrokeWidth = strokeWidth;
                this.mArcPaint.setStrokeWidth(strokeWidth);
                this.invalidateSelf();
            }

            public float getStartTrim() {
                return this.mStartTrim;
            }

            public void setStartTrim(float startTrim) {
                this.mStartTrim = startTrim;
                this.invalidateSelf();
            }

            public float getStartingStartTrim() {
                return this.mStartingStartTrim;
            }

            public float getStartingEndTrim() {
                return this.mStartingEndTrim;
            }

            public float getEndTrim() {
                return this.mEndTrim;
            }

            public void setEndTrim(float endTrim) {
                this.mEndTrim = endTrim;
                this.invalidateSelf();
            }

            public void setRotation(float rotation) {
                this.mRotation = rotation;
                this.invalidateSelf();
            }

            public void setInsets(int width, int height) {
                float minEdge = Math.min(width, height);
                float insets = this.mRingCenterRadius <= 0.0 || minEdge < 0.0f ? (float)Math.ceil(this.mStrokeWidth / 2.0f) : (float)((double)(minEdge / 2.0f) - this.mRingCenterRadius);
                this.mStrokeInset = insets;
            }

            public float getInsets() {
                return this.mStrokeInset;
            }

            public double getCenterRadius() {
                return this.mRingCenterRadius;
            }

            public void setCenterRadius(double centerRadius) {
                this.mRingCenterRadius = centerRadius;
            }

            public void setShowArrow(boolean show) {
                if (this.mShowArrow != show) {
                    this.mShowArrow = show;
                    this.invalidateSelf();
                }
            }

            public void setArrowScale(float scale) {
                if (scale != this.mArrowScale) {
                    this.mArrowScale = scale;
                    this.invalidateSelf();
                }
            }

            public float getStartingRotation() {
                return this.mStartingRotation;
            }

            public void storeOriginals() {
                this.mStartingStartTrim = this.mStartTrim;
                this.mStartingEndTrim = this.mEndTrim;
                this.mStartingRotation = this.mRotation;
            }

            public void resetOriginals() {
                this.mStartingStartTrim = 0.0f;
                this.mStartingEndTrim = 0.0f;
                this.mStartingRotation = 0.0f;
                this.setStartTrim(0.0f);
                this.setEndTrim(0.0f);
                this.setRotation(0.0f);
            }

            private void invalidateSelf() {
                this.mRingCallback.invalidateDrawable(null);
            }
        }
    }
}

