/*
 * Decompiled with CFR 0.152.
 */
package ch.ielse.view.imagewatcher;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import ch.ielse.view.imagewatcher.MaterialProgressView;
import ch.ielse.view.imagewatcher.R;
import ch.ielse.view.imagewatcher.ViewState;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import java.lang.ref.WeakReference;
import java.util.List;

public class ImageWatcher
extends FrameLayout
implements GestureDetector.OnGestureListener,
ViewPager.OnPageChangeListener {
    private static final int SINGLE_TAP_UP_CONFIRMED = 1;
    private final Handler mHandler;
    static final float MIN_SCALE = 0.5f;
    static final float MAX_SCALE = 3.8f;
    private int maxTranslateX;
    private int maxTranslateY;
    private static final int TOUCH_MODE_NONE = 0;
    private static final int TOUCH_MODE_DOWN = 1;
    private static final int TOUCH_MODE_DRAG = 2;
    private static final int TOUCH_MODE_EXIT = 3;
    private static final int TOUCH_MODE_SLIDE = 4;
    private static final int TOUCH_MODE_SCALE_ROTATE = 5;
    private static final int TOUCH_MODE_LOCK = 6;
    private static final int TOUCH_MODE_AUTO_FLING = 7;
    private TextView tCurrentIdx;
    private ImageView iSource;
    private ImageView iOrigin;
    private int mErrorImageRes = R.mipmap.error_picture;
    private int mStatusBarHeight;
    private int mWidth;
    private int mHeight;
    private int mBackgroundColor = 0;
    private int mTouchMode = 0;
    private float mTouchSlop;
    private float mFingersDistance;
    private double mFingersAngle;
    private float mFingersCenterX;
    private float mFingersCenterY;
    private float mExitScalingRef;
    private ValueAnimator animBackground;
    private ValueAnimator animImageTransform;
    private boolean isInTransformAnimation;
    private final GestureDetector mGestureDetector;
    private OnPictureLongPressListener mPictureLongPressListener;
    private ImagePagerAdapter adapter;
    private ViewPager vPager;
    private List<ImageView> mImageGroupList;
    private List<String> mUrlList;
    private int initPosition;
    private int mPagerPositionOffsetPixels;
    final AnimatorListenerAdapter mAnimTransitionStateListener = new AnimatorListenerAdapter(){

        public void onAnimationCancel(Animator animation) {
            ImageWatcher.this.isInTransformAnimation = false;
        }

        public void onAnimationStart(Animator animation) {
            ImageWatcher.this.isInTransformAnimation = true;
            ImageWatcher.this.mTouchMode = 7;
        }

        public void onAnimationEnd(Animator animation) {
            ImageWatcher.this.isInTransformAnimation = false;
        }
    };
    final TypeEvaluator<Integer> mColorEvaluator = new TypeEvaluator<Integer>(){

        public Integer evaluate(float fraction, Integer startValue, Integer endValue) {
            int startColor = startValue;
            int endColor = endValue;
            int alpha = (int)((float)Color.alpha((int)startColor) + fraction * (float)(Color.alpha((int)endColor) - Color.alpha((int)startColor)));
            int red = (int)((float)Color.red((int)startColor) + fraction * (float)(Color.red((int)endColor) - Color.red((int)startColor)));
            int green = (int)((float)Color.green((int)startColor) + fraction * (float)(Color.green((int)endColor) - Color.green((int)startColor)));
            int blue = (int)((float)Color.blue((int)startColor) + fraction * (float)(Color.blue((int)endColor) - Color.blue((int)startColor)));
            return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
        }
    };

    public ImageWatcher(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mHandler = new GestureHandler(this);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.vPager = new ViewPager(this.getContext());
        this.addView((View)this.vPager);
        this.vPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.setVisibility(4);
        this.tCurrentIdx = new TextView(context);
        this.addView((View)this.tCurrentIdx);
        FrameLayout.LayoutParams lpCurrentIdx = new FrameLayout.LayoutParams(-2, -2);
        lpCurrentIdx.gravity = 49;
        this.tCurrentIdx.setLayoutParams((ViewGroup.LayoutParams)lpCurrentIdx);
        this.tCurrentIdx.setTextColor(-1);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.tCurrentIdx.setTranslationY(TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics) + 0.5f);
    }

    public void show(ImageView i, List<ImageView> imageGroupList, List<String> urlList) {
        if (i == null || imageGroupList == null || urlList == null || imageGroupList.size() < 1 || urlList.size() < imageGroupList.size()) {
            String info = "i[" + i + "]";
            info = info + "#imageGroupList " + (imageGroupList == null ? "null" : "size : " + imageGroupList.size());
            info = info + "#urlList " + (urlList == null ? "null" : "size :" + urlList.size());
            throw new IllegalArgumentException("error params \n" + info);
        }
        this.initPosition = imageGroupList.indexOf(i);
        if (this.initPosition < 0) {
            throw new IllegalArgumentException("error params initPosition " + this.initPosition);
        }
        if (i.getDrawable() == null) {
            return;
        }
        if (this.animImageTransform != null) {
            this.animImageTransform.cancel();
        }
        this.animImageTransform = null;
        this.mImageGroupList = imageGroupList;
        this.mUrlList = urlList;
        this.iOrigin = null;
        this.iSource = null;
        this.setVisibility(0);
        this.adapter = new ImagePagerAdapter();
        this.vPager.setAdapter((PagerAdapter)this.adapter);
        this.vPager.setCurrentItem(this.initPosition);
        this.refreshCurrentIdx(this.initPosition);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.iSource == null) {
            return true;
        }
        if (this.isInTransformAnimation) {
            return true;
        }
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 1: {
                this.onUp(event);
                break;
            }
            case 5: {
                if ((vsDefault == null || this.mTouchMode == 4) && this.mPagerPositionOffsetPixels != 0) break;
                if (this.mTouchMode != 5) {
                    this.mFingersDistance = 0.0f;
                    this.mFingersAngle = 0.0;
                    this.mFingersCenterX = 0.0f;
                    this.mFingersCenterY = 0.0f;
                    ViewState.write((View)this.iSource, ViewState.STATE_TOUCH_SCALE_ROTATE);
                }
                this.mTouchMode = 5;
                break;
            }
            case 6: {
                if (vsDefault == null || this.mTouchMode == 4 || event.getPointerCount() - 1 >= 2) break;
                this.mTouchMode = 6;
            }
        }
        return this.mGestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent e) {
        this.mTouchMode = 1;
        ViewState.write((View)this.iSource, ViewState.STATE_TOUCH_DOWN);
        this.vPager.onTouchEvent(e);
        return true;
    }

    public void onUp(MotionEvent e) {
        if (this.mTouchMode == 3) {
            this.handleExitTouchResult();
        } else if (this.mTouchMode == 5 || this.mTouchMode == 6) {
            this.handleScaleRotateTouchResult();
        } else if (this.mTouchMode == 2) {
            this.handleDragTouchResult();
        }
        this.vPager.onTouchEvent(e);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float moveY;
        float moveX = e1 != null ? e2.getX() - e1.getX() : 0.0f;
        float f = moveY = e1 != null ? e2.getY() - e1.getY() : 0.0f;
        if (this.mTouchMode == 1 && (Math.abs(moveX) > this.mTouchSlop || Math.abs(moveY) > this.mTouchSlop)) {
            ViewState vsCurrent = ViewState.write((View)this.iSource, ViewState.STATE_CURRENT);
            ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
            if (vsDefault == null) {
                this.mTouchMode = 4;
            } else if (vsCurrent.scaleY > vsDefault.scaleY || vsCurrent.scaleX > vsDefault.scaleX) {
                if (this.mTouchMode != 2) {
                    ViewState.write((View)this.iSource, ViewState.STATE_DRAG);
                }
                this.mTouchMode = 2;
                String imageOrientation = (String)this.iSource.getTag(R.id.image_orientation);
                if ("horizontal".equals(imageOrientation)) {
                    float translateXEdge = (float)vsDefault.width * (vsCurrent.scaleX - 1.0f) / 2.0f;
                    if (vsCurrent.translationX >= translateXEdge && moveX > 0.0f) {
                        this.mTouchMode = 4;
                    } else if (vsCurrent.translationX <= -translateXEdge && moveX < 0.0f) {
                        this.mTouchMode = 4;
                    }
                } else if ("vertical".equals(imageOrientation)) {
                    if ((float)vsDefault.width * vsCurrent.scaleX <= (float)this.mWidth) {
                        this.mTouchMode = 4;
                    } else {
                        float translateXRightEdge = (float)vsDefault.width * vsCurrent.scaleX / 2.0f - (float)(vsDefault.width / 2);
                        float translateXLeftEdge = (float)this.mWidth - (float)vsDefault.width * vsCurrent.scaleX / 2.0f - (float)(vsDefault.width / 2);
                        if (vsCurrent.translationX >= translateXRightEdge && moveX > 0.0f) {
                            this.mTouchMode = 4;
                        } else if (vsCurrent.translationX <= translateXLeftEdge && moveX < 0.0f) {
                            this.mTouchMode = 4;
                        }
                    }
                }
            } else if (Math.abs(moveX) < this.mTouchSlop && moveY > this.mTouchSlop * 3.0f) {
                this.mTouchMode = 3;
            } else if (Math.abs(moveX) > this.mTouchSlop) {
                this.mTouchMode = 4;
            }
        }
        if (this.mTouchMode == 4) {
            this.vPager.onTouchEvent(e2);
        } else if (this.mTouchMode == 5) {
            this.handleScaleRotateGesture(e2);
        } else if (this.mTouchMode == 3) {
            this.handleExitGesture(e2, e1);
        } else if (this.mTouchMode == 2) {
            this.handleDragGesture(e2, e1);
        }
        return false;
    }

    public boolean onSingleTapConfirmed() {
        if (this.iSource == null) {
            return false;
        }
        ViewState vsCurrent = ViewState.write((View)this.iSource, ViewState.STATE_CURRENT);
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        this.mExitScalingRef = vsDefault == null || vsCurrent.scaleY <= vsDefault.scaleY && vsCurrent.scaleX <= vsDefault.scaleX ? 0.0f : 1.0f;
        this.handleExitTouchResult();
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        boolean hadTapMessage = this.mHandler.hasMessages(1);
        if (hadTapMessage) {
            this.mHandler.removeMessages(1);
            this.handleDoubleTapTouchResult();
            return true;
        }
        this.mHandler.sendEmptyMessageDelayed(1, 350L);
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public void onLongPress(MotionEvent e) {
        if (this.mPictureLongPressListener != null) {
            this.mPictureLongPressListener.onPictureLongPress(this.iSource, this.mUrlList.get(this.vPager.getCurrentItem()), this.vPager.getCurrentItem());
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    private void handleExitGesture(MotionEvent e2, MotionEvent e1) {
        if (this.iSource == null) {
            return;
        }
        ViewState vsTouchDown = ViewState.read((View)this.iSource, ViewState.STATE_TOUCH_DOWN);
        if (vsTouchDown == null) {
            return;
        }
        this.mExitScalingRef = 1.0f;
        float moveY = e2.getY() - e1.getY();
        float moveX = e2.getX() - e1.getX();
        if (moveY > 0.0f) {
            this.mExitScalingRef -= moveY / (float)this.getHeight();
        }
        if (this.mExitScalingRef < 0.5f) {
            this.mExitScalingRef = 0.5f;
        }
        this.iSource.setTranslationX(vsTouchDown.translationX + moveX);
        this.iSource.setTranslationY(vsTouchDown.translationY + moveY);
        this.iSource.setScaleX(vsTouchDown.scaleX * this.mExitScalingRef);
        this.iSource.setScaleY(vsTouchDown.scaleY * this.mExitScalingRef);
        this.setBackgroundColor((Integer)this.mColorEvaluator.evaluate(this.mExitScalingRef, (Object)0, (Object)-16777216));
    }

    private void handleScaleRotateGesture(MotionEvent e2) {
        float changedCenterX;
        float changedCenterXValue;
        float changedScale;
        float scaleResultX;
        float changedAngle;
        float changedAngleValue;
        if (this.iSource == null) {
            return;
        }
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        if (vsDefault == null) {
            return;
        }
        ViewState vsTouchScaleRotate = ViewState.read((View)this.iSource, ViewState.STATE_TOUCH_SCALE_ROTATE);
        if (vsTouchScaleRotate == null) {
            return;
        }
        if (e2.getPointerCount() < 2) {
            return;
        }
        float deltaX = e2.getX(1) - e2.getX(0);
        float deltaY = e2.getY(1) - e2.getY(0);
        double angle = Math.toDegrees(Math.atan(deltaX / deltaY));
        if (deltaY < 0.0f) {
            angle += 180.0;
        }
        if (this.mFingersAngle == 0.0) {
            this.mFingersAngle = angle;
        }
        if ((changedAngleValue = (vsTouchScaleRotate.rotation + (changedAngle = (float)(this.mFingersAngle - angle))) % 360.0f) > 180.0f) {
            changedAngleValue -= 360.0f;
        } else if (changedAngleValue < -180.0f) {
            changedAngleValue += 360.0f;
        }
        this.iSource.setRotation(changedAngleValue);
        float distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        if (this.mFingersDistance == 0.0f) {
            this.mFingersDistance = distance;
        }
        if ((scaleResultX = vsTouchScaleRotate.scaleX - (changedScale = (this.mFingersDistance - distance) / ((float)this.mWidth * 0.8f))) < 0.5f) {
            scaleResultX = 0.5f;
        } else if (scaleResultX > 3.8f) {
            scaleResultX = 3.8f;
        }
        this.iSource.setScaleX(scaleResultX);
        float scaleResultY = vsTouchScaleRotate.scaleY - changedScale;
        if (scaleResultY < 0.5f) {
            scaleResultY = 0.5f;
        } else if (scaleResultY > 3.8f) {
            scaleResultY = 3.8f;
        }
        this.iSource.setScaleY(scaleResultY);
        float centerX = (e2.getX(1) + e2.getX(0)) / 2.0f;
        float centerY = (e2.getY(1) + e2.getY(0)) / 2.0f;
        if (this.mFingersCenterX == 0.0f && this.mFingersCenterY == 0.0f) {
            this.mFingersCenterX = centerX;
            this.mFingersCenterY = centerY;
        }
        if ((changedCenterXValue = vsTouchScaleRotate.translationX - (changedCenterX = this.mFingersCenterX - centerX)) > (float)this.maxTranslateX) {
            changedCenterXValue = this.maxTranslateX;
        } else if (changedCenterXValue < (float)(-this.maxTranslateX)) {
            changedCenterXValue = -this.maxTranslateX;
        }
        this.iSource.setTranslationX(changedCenterXValue);
        float changedCenterY = this.mFingersCenterY - centerY;
        float changedCenterYValue = vsTouchScaleRotate.translationY - changedCenterY;
        if (changedCenterYValue > (float)this.maxTranslateY) {
            changedCenterYValue = this.maxTranslateY;
        } else if (changedCenterYValue < (float)(-this.maxTranslateY)) {
            changedCenterYValue = -this.maxTranslateY;
        }
        this.iSource.setTranslationY(changedCenterYValue);
    }

    private void handleDragGesture(MotionEvent e2, MotionEvent e1) {
        if (this.iSource == null) {
            return;
        }
        float moveY = e2.getY() - e1.getY();
        float moveX = e2.getX() - e1.getX();
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        if (vsDefault == null) {
            return;
        }
        ViewState vsTouchDrag = ViewState.read((View)this.iSource, ViewState.STATE_DRAG);
        if (vsTouchDrag == null) {
            return;
        }
        float translateXValue = vsTouchDrag.translationX + moveX * 1.6f;
        String imageOrientation = (String)this.iSource.getTag(R.id.image_orientation);
        if ("horizontal".equals(imageOrientation)) {
            float translateXEdge = (float)vsDefault.width * (vsTouchDrag.scaleX - 1.0f) / 2.0f;
            if (translateXValue > translateXEdge) {
                translateXValue = translateXEdge + (translateXValue - translateXEdge) * 0.12f;
            } else if (translateXValue < -translateXEdge) {
                translateXValue = -translateXEdge + (translateXValue - -translateXEdge) * 0.12f;
            }
        } else if ("vertical".equals(imageOrientation)) {
            if ((float)vsDefault.width * vsTouchDrag.scaleX <= (float)this.mWidth) {
                this.mTouchMode = 4;
            } else {
                float translateXRightEdge = (float)vsDefault.width * vsTouchDrag.scaleX / 2.0f - (float)(vsDefault.width / 2);
                float translateXLeftEdge = (float)this.mWidth - (float)vsDefault.width * vsTouchDrag.scaleX / 2.0f - (float)(vsDefault.width / 2);
                if (translateXValue > translateXRightEdge) {
                    translateXValue = translateXRightEdge + (translateXValue - translateXRightEdge) * 0.12f;
                } else if (translateXValue < translateXLeftEdge) {
                    translateXValue = translateXLeftEdge + (translateXValue - translateXLeftEdge) * 0.12f;
                }
            }
        }
        this.iSource.setTranslationX(translateXValue);
        this.iSource.setTranslationY(vsTouchDrag.translationY + moveY * 1.6f);
    }

    private void handleExitTouchResult() {
        if (this.iSource == null) {
            return;
        }
        if (this.mExitScalingRef > 0.9f) {
            ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
            if (vsDefault == null) {
                return;
            }
            this.animSourceViewStateTransform(this.iSource, vsDefault);
            this.animBackgroundTransform(-16777216);
        } else {
            ViewState vsOrigin = ViewState.read((View)this.iSource, ViewState.STATE_ORIGIN);
            if (vsOrigin == null) {
                return;
            }
            if (vsOrigin.alpha == 0.0f) {
                vsOrigin.translationX(this.iSource.getTranslationX()).translationY(this.iSource.getTranslationY());
            }
            this.animSourceViewStateTransform(this.iSource, vsOrigin);
            this.animBackgroundTransform(0);
            ((FrameLayout)this.iSource.getParent()).getChildAt(2).animate().alpha(0.0f).start();
        }
    }

    private void handleDoubleTapTouchResult() {
        if (this.iSource == null) {
            return;
        }
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        if (vsDefault == null) {
            return;
        }
        ViewState vsCurrent = ViewState.write((View)this.iSource, ViewState.STATE_CURRENT);
        if (vsCurrent.scaleY <= vsDefault.scaleY && vsCurrent.scaleX <= vsDefault.scaleX) {
            float expectedScale = (3.8f - vsDefault.scaleX) * 0.4f + vsDefault.scaleX;
            this.animSourceViewStateTransform(this.iSource, ViewState.write((View)this.iSource, ViewState.STATE_TEMP).scaleX(expectedScale).scaleY(expectedScale));
        } else {
            this.animSourceViewStateTransform(this.iSource, vsDefault);
        }
    }

    private void handleScaleRotateTouchResult() {
        if (this.iSource == null) {
            return;
        }
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        if (vsDefault == null) {
            return;
        }
        ViewState vsCurrent = ViewState.write((View)this.iSource, ViewState.STATE_CURRENT);
        Log.e((String)"TTT", (String)("AAA  vsCurrent.scaleX :" + vsCurrent.scaleX + "###  vsDefault.scaleX:" + vsDefault.scaleX));
        float endScaleX = vsCurrent.scaleX < vsDefault.scaleX ? vsDefault.scaleX : vsCurrent.scaleX;
        float endScaleY = vsCurrent.scaleY < vsDefault.scaleY ? vsDefault.scaleY : vsCurrent.scaleY;
        ViewState vsTemp = ViewState.copy(vsDefault, ViewState.STATE_TEMP).scaleX(endScaleX).scaleY(endScaleY);
        this.iSource.setTag(ViewState.STATE_TEMP, (Object)vsTemp);
        this.animSourceViewStateTransform(this.iSource, vsTemp);
        this.animBackgroundTransform(-16777216);
    }

    private void handleDragTouchResult() {
        float endTranslateY;
        float endTranslateX;
        if (this.iSource == null) {
            return;
        }
        ViewState vsDefault = ViewState.read((View)this.iSource, ViewState.STATE_DEFAULT);
        if (vsDefault == null) {
            return;
        }
        ViewState vsCurrent = ViewState.write((View)this.iSource, ViewState.STATE_CURRENT);
        String imageOrientation = (String)this.iSource.getTag(R.id.image_orientation);
        if ("horizontal".equals(imageOrientation)) {
            float translateXEdge = (float)vsDefault.width * (vsCurrent.scaleX - 1.0f) / 2.0f;
            endTranslateX = vsCurrent.translationX > translateXEdge ? translateXEdge : (vsCurrent.translationX < -translateXEdge ? -translateXEdge : vsCurrent.translationX);
            if ((float)vsDefault.height * vsCurrent.scaleY <= (float)this.mHeight) {
                endTranslateY = vsDefault.translationY;
            } else {
                float translateYBottomEdge = (float)vsDefault.height * vsCurrent.scaleY / 2.0f - (float)(vsDefault.height / 2);
                float translateYTopEdge = (float)this.mHeight - (float)vsDefault.height * vsCurrent.scaleY / 2.0f - (float)(vsDefault.height / 2);
                endTranslateY = vsCurrent.translationY > translateYBottomEdge ? translateYBottomEdge : (vsCurrent.translationY < translateYTopEdge ? translateYTopEdge : vsCurrent.translationY);
            }
        } else if ("vertical".equals(imageOrientation)) {
            float translateYEdge = (float)vsDefault.height * (vsCurrent.scaleY - 1.0f) / 2.0f;
            endTranslateY = vsCurrent.translationY > translateYEdge ? translateYEdge : (vsCurrent.translationY < -translateYEdge ? -translateYEdge : vsCurrent.translationY);
            if ((float)vsDefault.width * vsCurrent.scaleX <= (float)this.mWidth) {
                endTranslateX = vsDefault.translationX;
            } else {
                float translateXRightEdge = (float)vsDefault.width * vsCurrent.scaleX / 2.0f - (float)(vsDefault.width / 2);
                float translateXLeftEdge = (float)this.mWidth - (float)vsDefault.width * vsCurrent.scaleX / 2.0f - (float)(vsDefault.width / 2);
                endTranslateX = vsCurrent.translationX > translateXRightEdge ? translateXRightEdge : (vsCurrent.translationX < translateXLeftEdge ? translateXLeftEdge : vsCurrent.translationX);
            }
        } else {
            return;
        }
        if (vsCurrent.translationX == endTranslateX && vsCurrent.translationY == endTranslateY) {
            return;
        }
        this.animSourceViewStateTransform(this.iSource, ViewState.write((View)this.iSource, ViewState.STATE_TEMP).translationX(endTranslateX).translationY(endTranslateY));
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mPagerPositionOffsetPixels = positionOffsetPixels;
    }

    public void onPageSelected(int position) {
        ImageView mNext;
        this.iSource = (ImageView)this.adapter.mImageSparseArray.get(position);
        if (this.iOrigin != null) {
            this.iOrigin.setVisibility(0);
        }
        if (position < this.mImageGroupList.size()) {
            this.iOrigin = this.mImageGroupList.get(position);
            if (this.iOrigin.getDrawable() != null) {
                this.iOrigin.setVisibility(4);
            }
        }
        this.refreshCurrentIdx(position);
        ImageView mLast = (ImageView)this.adapter.mImageSparseArray.get(position - 1);
        if (ViewState.read((View)mLast, ViewState.STATE_DEFAULT) != null) {
            ViewState.restoreByAnim((View)mLast, ViewState.STATE_DEFAULT).create().start();
        }
        if (ViewState.read((View)(mNext = (ImageView)this.adapter.mImageSparseArray.get(position + 1)), ViewState.STATE_DEFAULT) != null) {
            ViewState.restoreByAnim((View)mNext, ViewState.STATE_DEFAULT).create().start();
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mPagerPositionOffsetPixels == 0;
    }

    public void setTranslucentStatus(int statusBarHeight) {
        this.mStatusBarHeight = statusBarHeight;
    }

    public void setErrorImageRes(int resErrorImage) {
        this.mErrorImageRes = resErrorImage;
    }

    private void refreshCurrentIdx(int position) {
        if (this.mUrlList.size() > 1) {
            this.tCurrentIdx.setVisibility(0);
            this.tCurrentIdx.setText((CharSequence)(position + 1 + " / " + this.mUrlList.size()));
        } else {
            this.tCurrentIdx.setVisibility(8);
        }
    }

    public void setBackgroundColor(int color) {
        this.mBackgroundColor = color;
        super.setBackgroundColor(color);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.maxTranslateX = this.mWidth / 2;
        this.maxTranslateY = this.mHeight / 2;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.animImageTransform != null) {
            this.animImageTransform.cancel();
        }
        this.animImageTransform = null;
        if (this.animBackground != null) {
            this.animBackground.cancel();
        }
        this.animBackground = null;
    }

    public boolean handleBackPressed() {
        return this.isInTransformAnimation || this.iSource != null && this.getVisibility() == 0 && this.onSingleTapConfirmed();
    }

    private void animSourceViewStateTransform(ImageView view, ViewState vsResult) {
        if (view == null) {
            return;
        }
        if (this.animImageTransform != null) {
            this.animImageTransform.cancel();
        }
        this.animImageTransform = ViewState.restoreByAnim((View)view, vsResult.mTag).addListener((Animator.AnimatorListener)this.mAnimTransitionStateListener).create();
        if (this.animImageTransform != null) {
            if (vsResult.mTag == ViewState.STATE_ORIGIN) {
                this.animImageTransform.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        if (ImageWatcher.this.iOrigin != null) {
                            ImageWatcher.this.iOrigin.setVisibility(0);
                        }
                        ImageWatcher.this.setVisibility(8);
                    }
                });
            }
            this.animImageTransform.start();
        }
    }

    private void animBackgroundTransform(final int colorResult) {
        if (colorResult == this.mBackgroundColor) {
            return;
        }
        if (this.animBackground != null) {
            this.animBackground.cancel();
        }
        final int mCurrentBackgroundColor = this.mBackgroundColor;
        this.animBackground = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(300L);
        this.animBackground.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float p = ((Float)animation.getAnimatedValue()).floatValue();
                ImageWatcher.this.setBackgroundColor((Integer)ImageWatcher.this.mColorEvaluator.evaluate(p, (Object)mCurrentBackgroundColor, (Object)colorResult));
            }
        });
        this.animBackground.start();
    }

    public void setOnPictureLongPressListener(OnPictureLongPressListener listener) {
        this.mPictureLongPressListener = listener;
    }

    public static interface OnPictureLongPressListener {
        public void onPictureLongPress(ImageView var1, String var2, int var3);
    }

    private static class GestureHandler
    extends Handler {
        WeakReference<ImageWatcher> mRef;

        GestureHandler(ImageWatcher ref) {
            this.mRef = new WeakReference<ImageWatcher>(ref);
        }

        public void handleMessage(Message msg) {
            if (this.mRef.get() != null) {
                ImageWatcher holder = (ImageWatcher)((Object)this.mRef.get());
                switch (msg.what) {
                    case 1: {
                        holder.onSingleTapConfirmed();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown message " + msg);
                    }
                }
            }
        }
    }

    class ImagePagerAdapter
    extends PagerAdapter {
        private final FrameLayout.LayoutParams lpCenter = new FrameLayout.LayoutParams(-1, -1);
        private final SparseArray<ImageView> mImageSparseArray = new SparseArray();
        private boolean hasPlayBeginAnimation;

        ImagePagerAdapter() {
        }

        public int getCount() {
            return ImageWatcher.this.mUrlList != null ? ImageWatcher.this.mUrlList.size() : 0;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
            this.mImageSparseArray.remove(position);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            FrameLayout itemView = new FrameLayout(container.getContext());
            container.addView((View)itemView);
            ImageView imageView = new ImageView(container.getContext());
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            itemView.addView((View)imageView);
            this.mImageSparseArray.put(position, (Object)imageView);
            MaterialProgressView loadView = new MaterialProgressView(container.getContext());
            this.lpCenter.gravity = 17;
            loadView.setLayoutParams((ViewGroup.LayoutParams)this.lpCenter);
            itemView.addView((View)loadView);
            ImageView errorView = new ImageView(container.getContext());
            errorView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            errorView.setImageResource(ImageWatcher.this.mErrorImageRes);
            itemView.addView((View)errorView);
            errorView.setVisibility(8);
            if (this.setDefaultDisplayConfigs(imageView, position, this.hasPlayBeginAnimation)) {
                this.hasPlayBeginAnimation = true;
            }
            return itemView;
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        void notifyItemChangedState(int position, boolean loading, boolean error) {
            ImageView imageView = (ImageView)this.mImageSparseArray.get(position);
            if (imageView != null) {
                FrameLayout itemView = (FrameLayout)imageView.getParent();
                MaterialProgressView loadView = (MaterialProgressView)itemView.getChildAt(1);
                if (loading) {
                    loadView.setVisibility(0);
                    loadView.start();
                } else {
                    loadView.stop();
                    loadView.setVisibility(8);
                }
                ImageView errorView = (ImageView)itemView.getChildAt(2);
                errorView.setAlpha(1.0f);
                errorView.setVisibility(error ? 0 : 8);
            }
        }

        private boolean setDefaultDisplayConfigs(final ImageView imageView, final int pos, boolean hasPlayBeginAnimation) {
            boolean isFindEnterImagePicture = false;
            ViewState.write((View)imageView, ViewState.STATE_ORIGIN).alpha(0.0f).scaleXBy(1.5f).scaleYBy(1.5f);
            if (pos < ImageWatcher.this.mImageGroupList.size()) {
                ImageView originRef = (ImageView)ImageWatcher.this.mImageGroupList.get(pos);
                if (pos == ImageWatcher.this.initPosition && !hasPlayBeginAnimation) {
                    isFindEnterImagePicture = true;
                    ImageWatcher.this.iSource = imageView;
                    ImageWatcher.this.iOrigin = originRef;
                }
                int[] location = new int[2];
                originRef.getLocationOnScreen(location);
                imageView.setTranslationX((float)location[0]);
                int locationYOfFullScreen = location[1];
                imageView.setTranslationY((float)(locationYOfFullScreen -= ImageWatcher.this.mStatusBarHeight));
                imageView.getLayoutParams().width = originRef.getWidth();
                imageView.getLayoutParams().height = originRef.getHeight();
                ViewState.write((View)imageView, ViewState.STATE_ORIGIN).width(originRef.getWidth()).height(originRef.getHeight());
                Drawable bmpMirror = originRef.getDrawable();
                if (bmpMirror != null) {
                    int bmpMirrorWidth = bmpMirror.getBounds().width();
                    int bmpMirrorHeight = bmpMirror.getBounds().height();
                    ViewState vsThumb = ViewState.write((View)imageView, ViewState.STATE_THUMB).width(bmpMirrorWidth).height(bmpMirrorHeight).translationX((ImageWatcher.this.mWidth - bmpMirrorWidth) / 2).translationY((ImageWatcher.this.mHeight - bmpMirrorHeight) / 2);
                    imageView.setImageDrawable(bmpMirror);
                    if (isFindEnterImagePicture) {
                        ImageWatcher.this.animSourceViewStateTransform(imageView, vsThumb);
                    } else {
                        ViewState.restore((View)imageView, vsThumb.mTag);
                    }
                }
            }
            final boolean isPlayEnterAnimation = isFindEnterImagePicture;
            ViewState.clear((View)imageView, ViewState.STATE_DEFAULT);
            Glide.with((Context)imageView.getContext()).load((String)ImageWatcher.this.mUrlList.get(pos)).asBitmap().into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                    int sourceDefaultTranslateY;
                    int sourceDefaultTranslateX;
                    int sourceDefaultHeight;
                    int sourceDefaultWidth;
                    int resourceImageHeight;
                    int resourceImageWidth = resource.getWidth();
                    if ((float)resourceImageWidth * 1.0f / (float)(resourceImageHeight = resource.getHeight()) > (float)ImageWatcher.this.mWidth * 1.0f / (float)ImageWatcher.this.mHeight) {
                        sourceDefaultWidth = ImageWatcher.this.mWidth;
                        sourceDefaultHeight = (int)((float)sourceDefaultWidth * 1.0f / (float)resourceImageWidth * (float)resourceImageHeight);
                        sourceDefaultTranslateX = 0;
                        sourceDefaultTranslateY = (ImageWatcher.this.mHeight - sourceDefaultHeight) / 2;
                        imageView.setTag(R.id.image_orientation, (Object)"horizontal");
                    } else {
                        sourceDefaultHeight = ImageWatcher.this.mHeight;
                        sourceDefaultWidth = (int)((float)sourceDefaultHeight * 1.0f / (float)resourceImageHeight * (float)resourceImageWidth);
                        sourceDefaultTranslateY = 0;
                        sourceDefaultTranslateX = (ImageWatcher.this.mWidth - sourceDefaultWidth) / 2;
                        imageView.setTag(R.id.image_orientation, (Object)"vertical");
                    }
                    imageView.setImageBitmap(resource);
                    ImagePagerAdapter.this.notifyItemChangedState(pos, false, false);
                    ViewState vsDefault = ViewState.write((View)imageView, ViewState.STATE_DEFAULT).width(sourceDefaultWidth).height(sourceDefaultHeight).translationX(sourceDefaultTranslateX).translationY(sourceDefaultTranslateY);
                    if (isPlayEnterAnimation) {
                        ImageWatcher.this.animSourceViewStateTransform(imageView, vsDefault);
                    } else {
                        ViewState.restore((View)imageView, vsDefault.mTag);
                        imageView.setAlpha(0.0f);
                        imageView.animate().alpha(1.0f).start();
                    }
                }

                public void onLoadStarted(Drawable placeholder) {
                    ImagePagerAdapter.this.notifyItemChangedState(pos, true, false);
                }

                public void onLoadFailed(Exception e, Drawable errorDrawable) {
                    ImagePagerAdapter.this.notifyItemChangedState(pos, false, imageView.getDrawable() == null);
                }
            });
            if (isPlayEnterAnimation) {
                ImageWatcher.this.iOrigin.setVisibility(4);
                ImageWatcher.this.animBackgroundTransform(-16777216);
            }
            return isPlayEnterAnimation;
        }
    }
}

