/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Test;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.AbstractOrganizableObject;
import step.core.accessors.Accessor;

public abstract class AbstractAccessorTest {
    protected Accessor<AbstractIdentifiableObject> accessor;
    protected Accessor<AbstractOrganizableObject> organizableObjectAccessor;
    protected Accessor<Bean> beanAccessor;

    @Test
    public void testIdentifiableObjectAccessor() {
        AbstractIdentifiableObject entity = new AbstractIdentifiableObject();
        this.accessor.save(entity);
        AbstractIdentifiableObject actualEntity = this.accessor.get(entity.getId());
        Assert.assertEquals((Object)entity, (Object)actualEntity);
        actualEntity = this.accessor.get(entity.getId().toString());
        Assert.assertEquals((Object)entity, (Object)actualEntity);
        List range = this.accessor.getRange(0, 1);
        Assert.assertEquals((long)1L, (long)range.size());
        Assert.assertEquals((Object)entity, range.get(0));
        range = this.accessor.getRange(10, 1);
        Assert.assertEquals((long)0L, (long)range.size());
        List all = this.accessor.stream().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)all.size());
        all.clear();
        this.accessor.getAll().forEachRemaining(e -> all.add(e));
        Assert.assertEquals((long)1L, (long)all.size());
        all.clear();
        this.accessor.remove(entity.getId());
        this.accessor.getAll().forEachRemaining(e -> all.add(e));
        Assert.assertEquals((long)0L, (long)all.size());
        ArrayList<AbstractIdentifiableObject> entities = new ArrayList<AbstractIdentifiableObject>();
        entities.add(new AbstractIdentifiableObject());
        entities.add(new AbstractIdentifiableObject());
        this.accessor.save(entities);
        this.accessor.getAll().forEachRemaining(e -> all.add(e));
        Assert.assertEquals((long)2L, (long)all.size());
        entity = new AbstractIdentifiableObject();
        entity.setId(null);
        this.accessor.save(entity);
        Assert.assertNotNull((Object)entity.getId());
    }

    @Test
    public void testBeanAccessor() {
        Bean entity = new Bean();
        entity.setProperty1("value 1");
        this.beanAccessor.save((AbstractIdentifiableObject)entity);
        Bean actualEntity = (Bean)this.beanAccessor.get(entity.getId());
        Assert.assertEquals((Object)((Object)entity), (Object)((Object)actualEntity));
        actualEntity = (Bean)this.beanAccessor.get(entity.getId().toString());
        Assert.assertEquals((Object)((Object)entity), (Object)((Object)actualEntity));
        actualEntity = (Bean)this.beanAccessor.findByCriteria(Map.of("property1", "value 1"));
        Assert.assertEquals((Object)((Object)entity), (Object)((Object)actualEntity));
        actualEntity = (Bean)((Object)this.beanAccessor.findManyByCriteria(Map.of("property1", "value 1")).findFirst().get());
        Assert.assertEquals((Object)((Object)entity), (Object)((Object)actualEntity));
    }

    @Test
    public void testFindByAttributes() {
        AbstractOrganizableObject entity = new AbstractOrganizableObject();
        entity.addAttribute("att1", "val1");
        entity.addAttribute("att2", "val2");
        this.testFindByAttributes(this.organizableObjectAccessor, entity, true);
    }

    @Test
    public void testFindByCustomFields() {
        AbstractOrganizableObject entity = new AbstractOrganizableObject();
        entity.addCustomField("att1", (Object)"val1");
        entity.addCustomField("att2", (Object)"val2");
        this.testFindByAttributes(this.organizableObjectAccessor, entity, false);
    }

    private void testFindByAttributes(Accessor<AbstractOrganizableObject> inMemoryAccessor, AbstractOrganizableObject entity, boolean findAttributes) {
        inMemoryAccessor.save((AbstractIdentifiableObject)entity);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("att1", "val1");
        AbstractIdentifiableObject actual = this.findByAttributes(inMemoryAccessor, findAttributes, attributes);
        Assert.assertEquals((Object)entity, (Object)actual);
        attributes.clear();
        attributes.put("att1", "val2");
        actual = this.findByAttributes(inMemoryAccessor, findAttributes, attributes);
        Assert.assertEquals(null, (Object)actual);
        actual = this.findByAttributes(inMemoryAccessor, findAttributes, attributes);
        Assert.assertEquals(null, (Object)actual);
        attributes.clear();
        attributes.put("att1", "val1");
        attributes.put("att2", "val2");
        actual = this.findByAttributes(inMemoryAccessor, findAttributes, attributes);
        Assert.assertEquals((Object)entity, (Object)actual);
        actual = this.findByAttributes(inMemoryAccessor, findAttributes, attributes);
        Assert.assertEquals((Object)entity, (Object)actual);
        AbstractOrganizableObject entity2 = new AbstractOrganizableObject();
        inMemoryAccessor.save((AbstractIdentifiableObject)entity2);
        Spliterator<AbstractOrganizableObject> findManyByAttributes = this.findManyByAttributes(inMemoryAccessor, findAttributes, null);
        Assert.assertEquals((long)2L, (long)StreamSupport.stream(findManyByAttributes, false).collect(Collectors.toList()).size());
        findManyByAttributes = this.findManyByAttributes(inMemoryAccessor, findAttributes, new HashMap<String, String>());
        Assert.assertEquals((long)2L, (long)StreamSupport.stream(findManyByAttributes, false).collect(Collectors.toList()).size());
        findManyByAttributes = this.findManyByAttributes(inMemoryAccessor, findAttributes, attributes);
        Assert.assertEquals((long)1L, (long)StreamSupport.stream(findManyByAttributes, false).collect(Collectors.toList()).size());
        findManyByAttributes = this.findManyByAttributes(inMemoryAccessor, findAttributes, null);
        Assert.assertEquals((long)2L, (long)StreamSupport.stream(findManyByAttributes, false).collect(Collectors.toList()).size());
    }

    private Spliterator<AbstractOrganizableObject> findManyByAttributes(Accessor<AbstractOrganizableObject> inMemoryAccessor, boolean findAttributes, HashMap<String, String> attributes) {
        if (findAttributes) {
            return inMemoryAccessor.findManyByAttributes(attributes, "attributes");
        }
        return inMemoryAccessor.findManyByAttributes(attributes, "customFields");
    }

    private AbstractIdentifiableObject findByAttributes(Accessor<AbstractOrganizableObject> inMemoryAccessor, boolean findAttributes, HashMap<String, String> attributes) {
        AbstractIdentifiableObject actual = findAttributes ? inMemoryAccessor.findByAttributes(attributes, "attributes") : inMemoryAccessor.findByAttributes(attributes, "customFields");
        return actual;
    }

    public static class Bean
    extends AbstractIdentifiableObject {
        private String property1;

        public String getProperty1() {
            return this.property1;
        }

        public void setProperty1(String property1) {
            this.property1 = property1;
        }
    }
}

