/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EscapingDottedKeysMapDeserializer
extends JsonDeserializer<Map> {
    private ObjectMapper mapper = new ObjectMapper();

    public EscapingDottedKeysMapDeserializer() {
        this.mapper.enableDefaultTyping();
    }

    private String decodeKey(String key) {
        return key.replace("\\\\u002e", ".").replace("\\\\u0024", "\\$").replace("\\\\\\\\", "\\\\");
    }

    public Map deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        HashMap result = new HashMap();
        ObjectNode o = (ObjectNode)node;
        o.fields().forEachRemaining(e -> {
            String key = (String)e.getKey();
            JsonNode eNode = (JsonNode)e.getValue();
            try {
                result.put(this.decodeKey(key), this.mapper.treeToValue((TreeNode)eNode, Object.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        return result;
    }
}

