/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;

public class DefaultJacksonMapperProvider {
    private static List<Module> customModules = new ArrayList<Module>();
    private static List<Module> modules = new ArrayList<Module>();
    private static Class<ObjectId> _id = ObjectId.class;

    public static List<Module> getCustomModules() {
        return customModules;
    }

    public static ObjectMapper getObjectMapper(JsonFactory factory) {
        ObjectMapper objectMapper = new ObjectMapper(factory);
        DefaultJacksonMapperProvider.configure(objectMapper);
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        DefaultJacksonMapperProvider.configure(objectMapper);
        return objectMapper;
    }

    private static void configure(ObjectMapper objectMapper) {
        customModules.forEach(m -> objectMapper.registerModule(m));
        modules.forEach(m -> objectMapper.registerModule(m));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static JsonDeserializer<ObjectId> _idDeserializer() {
        return new JsonDeserializer<ObjectId>(){

            public ObjectId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return new ObjectId((String)jp.readValueAs(String.class));
            }
        };
    }

    private static JsonSerializer<Object> _idSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(obj == null ? null : obj.toString());
            }
        };
    }

    static {
        customModules.add((Module)new JSR353Module());
        customModules.add((Module)new JsonOrgModule());
        modules.add((Module)new SimpleModule("jersey", new Version(1, 0, 0, null, null, null)).addSerializer(_id, DefaultJacksonMapperProvider._idSerializer()).addDeserializer(_id, DefaultJacksonMapperProvider._idDeserializer()));
    }
}

