/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.Accessor;
import step.core.accessors.InMemoryAccessor;

public class CachedAccessor<T extends AbstractIdentifiableObject>
implements Accessor<T> {
    private final Accessor<T> cache = new InMemoryAccessor();
    private final Accessor<T> underlyingAccessor;

    public CachedAccessor(Accessor<T> underlyingAccessor) {
        this.underlyingAccessor = underlyingAccessor;
        this.reloadCache();
    }

    public void reloadCache() {
        this.underlyingAccessor.getAll().forEachRemaining(e -> this.cache.save((AbstractIdentifiableObject)e));
    }

    @Override
    public T get(ObjectId id) {
        return this.cache.get(id);
    }

    @Override
    public T get(String id) {
        return this.cache.get(id);
    }

    @Override
    public T findByAttributes(Map<String, String> attributes) {
        return this.cache.findByAttributes(attributes);
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        return this.cache.findManyByAttributes(attributes);
    }

    @Override
    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.cache.findByAttributes(attributes, attributesMapKey);
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.cache.findManyByAttributes(attributes, attributesMapKey);
    }

    @Override
    public Iterator<T> getAll() {
        return this.cache.getAll();
    }

    @Override
    public void remove(ObjectId id) {
        this.cache.remove(id);
        this.underlyingAccessor.remove(id);
    }

    @Override
    public T save(T entity) {
        T result = this.underlyingAccessor.save(entity);
        this.cache.save(result);
        return result;
    }

    @Override
    public void save(Iterable<T> entities) {
        entities.forEach(e -> this.save(e));
    }

    @Override
    public List<T> getRange(int skip, int limit) {
        return this.cache.getRange(skip, limit);
    }
}

