/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.Accessor;
import step.core.collections.Collection;
import step.core.collections.Filter;
import step.core.collections.Filters;

public class AbstractAccessor<T extends AbstractIdentifiableObject>
implements Accessor<T> {
    protected final Collection<T> collectionDriver;

    public AbstractAccessor(Collection<T> collectionDriver) {
        this.collectionDriver = collectionDriver;
    }

    public Collection<T> getCollectionDriver() {
        return this.collectionDriver;
    }

    @Override
    public T get(ObjectId id) {
        return (T)((AbstractIdentifiableObject)this.collectionDriver.find(this.byId(id), null, null, null, 0).findFirst().orElse(null));
    }

    @Override
    public T get(String id) {
        return this.get(new ObjectId(id));
    }

    @Override
    public T findByAttributes(Map<String, String> attributes) {
        return this.findByKeyAttributes("attributes", attributes);
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        return this.findByAttributesStream("attributes", attributes).spliterator();
    }

    @Override
    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.findByKeyAttributes(attributesMapKey, attributes);
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.findByAttributesStream(attributesMapKey, attributes).spliterator();
    }

    private T findByKeyAttributes(String fieldName, Map<String, String> attributes) {
        Stream<T> stream = this.findByAttributesStream(fieldName, attributes);
        return (T)((AbstractIdentifiableObject)stream.findFirst().orElse(null));
    }

    private Stream<T> findByAttributesStream(String fieldName, Map<String, String> attributes) {
        Filter filter = attributes != null ? Filters.and(attributes.entrySet().stream().map(e -> Filters.equals(fieldName + "." + (String)e.getKey(), (String)e.getValue())).collect(Collectors.toList())) : Filters.empty();
        return this.collectionDriver.find(filter, null, null, null, 0);
    }

    @Override
    public Iterator<T> getAll() {
        return this.collectionDriver.find(Filters.empty(), null, null, null, 0).iterator();
    }

    public Stream<T> stream() {
        return this.collectionDriver.find(Filters.empty(), null, null, null, 0);
    }

    @Override
    public void remove(ObjectId id) {
        this.collectionDriver.remove(this.byId(id));
    }

    private Filters.Equals byId(ObjectId id) {
        return Filters.equals("id", id);
    }

    @Override
    public T save(T entity) {
        return (T)((AbstractIdentifiableObject)this.collectionDriver.save(entity));
    }

    @Override
    public void save(Iterable<T> entities) {
        this.collectionDriver.save(entities);
    }

    @Override
    public List<T> getRange(int skip, int limit) {
        return this.collectionDriver.find(Filters.empty(), null, skip, limit, 0).collect(Collectors.toList());
    }

    protected void createOrUpdateIndex(String field) {
        this.collectionDriver.createOrUpdateIndex(field);
    }

    protected void createOrUpdateCompoundIndex(String ... fields) {
        this.collectionDriver.createOrUpdateCompoundIndex(fields);
    }
}

