/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.maven;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import step.client.credentials.ControllerCredentials;
import step.controller.multitenancy.Tenant;
import step.controller.multitenancy.client.MultitenancyClient;
import step.controller.multitenancy.client.RemoteMultitenancyClientImpl;
import step.plugins.maven.AbstractUploadKeywordsPackageMojo;
import step.plugins.maven.TenantSwitcher;

@Mojo(name="upload-keywords-package-ee")
public class UploadKeywordsPackageMojoEE
extends AbstractUploadKeywordsPackageMojo {
    @Parameter(property="step.step-project-name", required=true)
    private String stepProjectName;
    @Parameter(property="step.auth-token", required=false)
    private String authToken;

    public String getStepProjectName() {
        return this.stepProjectName;
    }

    public void setStepProjectName(String stepProjectName) {
        this.stepProjectName = stepProjectName;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    protected ControllerCredentials getControllerCredentials() {
        return new ControllerCredentials(this.getUrl(), this.getAuthToken());
    }

    protected void fillAdditionalPackageSearchCriteria(Map<String, String> searchCriteria) throws MojoExecutionException {
        super.fillAdditionalPackageSearchCriteria(searchCriteria);
        if (this.getStepProjectName() != null && !this.getStepProjectName().isEmpty()) {
            this.getLog().info((CharSequence)("Step project name: " + this.getStepProjectName()));
            TenantSwitcher tenantSwitcher = new TenantSwitcher(){

                @Override
                protected MultitenancyClient createClient() {
                    return UploadKeywordsPackageMojoEE.this.createMultitenancyClient();
                }
            };
            try {
                Tenant currentTenant = tenantSwitcher.switchTenant(this.getStepProjectName());
                this.getLog().info((CharSequence)("Current tenant: " + currentTenant.getName() + " (" + currentTenant.getProjectId() + "). Is global: " + currentTenant.isGlobal()));
                searchCriteria.put("attributes.project", currentTenant.getProjectId());
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Unable to switch tenant");
                throw this.logAndThrow(e.getMessage(), e);
            }
        }
    }

    protected MultitenancyClient createMultitenancyClient() {
        return new RemoteMultitenancyClientImpl(this.getControllerCredentials());
    }
}

