/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.maven;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import step.client.credentials.ControllerCredentials;
import step.controller.multitenancy.Tenant;
import step.controller.multitenancy.client.MultitenancyClient;
import step.controller.multitenancy.client.RemoteMultitenancyClientImpl;
import step.core.execution.model.ExecutionParameters;
import step.plugins.maven.AbstractRunPackagedAutomationPackagesMojo;
import step.plugins.maven.TenantSwitcher;

@Mojo(name="run-packaged-automation-packages-ee")
public class RunPackagedAutomationPackagesMojoEE
extends AbstractRunPackagedAutomationPackagesMojo {
    @Parameter(property="step.step-project-name", required=true)
    private String stepProjectName;
    @Parameter(property="step-run-auto-packages.user-id", required=false)
    private String userId;
    @Parameter(property="step.auth-token", required=false)
    private String authToken;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getStepProjectName() != null && !this.getStepProjectName().isEmpty()) {
            this.getLog().info((CharSequence)("Step project name: " + this.getStepProjectName()));
            TenantSwitcher tenantSwitcher = new TenantSwitcher(){

                @Override
                protected MultitenancyClient createClient() {
                    return RunPackagedAutomationPackagesMojoEE.this.createMultitenancyClient();
                }
            };
            try {
                Tenant currentTenant = tenantSwitcher.switchTenant(this.getStepProjectName());
                this.getLog().info((CharSequence)("Current tenant: " + currentTenant.getName() + " (" + currentTenant.getProjectId() + "). Is global: " + currentTenant.isGlobal()));
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)"Unable to switch tenant");
                throw this.logAndThrow(e.getMessage(), e);
            }
        }
        super.execute();
    }

    protected ControllerCredentials getControllerCredentials() {
        return new ControllerCredentials(this.getUrl(), this.getAuthToken());
    }

    protected ExecutionParameters prepareExecutionParameters(Map<String, Object> executionContext) {
        ExecutionParameters res = super.prepareExecutionParameters(executionContext);
        res.setUserID(this.getUserId());
        return res;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getStepProjectName() {
        return this.stepProjectName;
    }

    public void setStepProjectName(String stepProjectName) {
        this.stepProjectName = stepProjectName;
    }

    protected MultitenancyClient createMultitenancyClient() {
        return new RemoteMultitenancyClientImpl(this.getControllerCredentials());
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

