/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.maven;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import step.client.credentials.ControllerCredentials;
import step.controller.multitenancy.Tenant;
import step.controller.multitenancy.client.MultitenancyClient;
import step.controller.multitenancy.client.RemoteMultitenancyClientImpl;
import step.core.execution.model.ExecutionParameters;
import step.plugins.maven.AbstractRunDeployedAutomationPackagesMojo;
import step.plugins.maven.TenantSwitcher;

@Mojo(name="run-deployed-automation-packages-ee")
public class RunDeployedAutomationPackagesMojoEE
extends AbstractRunDeployedAutomationPackagesMojo {
    @Parameter(property="step.step-project-name", required=true)
    private String stepProjectName;
    @Parameter(property="step-run-auto-packages.user-id", required=false)
    private String userId;
    @Parameter(property="step.auth-token", required=false)
    private String authToken;

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public void execute() throws MojoExecutionException {
        if (this.getStepProjectName() != null && !this.getStepProjectName().isEmpty()) {
            this.getLog().info((CharSequence)("Step project name: " + this.getStepProjectName()));
            TenantSwitcher tenantSwitcher = new TenantSwitcher(){

                @Override
                protected MultitenancyClient createClient() {
                    return RunDeployedAutomationPackagesMojoEE.this.createMultitenancyClient();
                }
            };
            try {
                Tenant currentTenant = tenantSwitcher.switchTenant(this.getStepProjectName());
                this.getLog().info((CharSequence)("Current tenant: " + currentTenant.getName() + " (" + currentTenant.getProjectId() + "). Is global: " + currentTenant.isGlobal()));
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)"Unable to switch tenant");
                throw this.logAndThrow(e.getMessage(), e);
            }
        }
        super.execute();
    }

    protected ExecutionParameters prepareExecutionParameters(Map<String, Object> executionContext) {
        ExecutionParameters res = super.prepareExecutionParameters(executionContext);
        res.setUserID(this.getUserId());
        return res;
    }

    protected ControllerCredentials getControllerCredentials() {
        return new ControllerCredentials(this.getUrl(), this.getAuthToken());
    }

    protected MultitenancyClient createMultitenancyClient() {
        return new RemoteMultitenancyClientImpl(this.getControllerCredentials());
    }

    public String getStepProjectName() {
        return this.stepProjectName;
    }

    public void setStepProjectName(String stepProjectName) {
        this.stepProjectName = stepProjectName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

