/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala;

import ch.epfl.scala.AnalyzeDependencyGraph;
import ch.epfl.scala.GithubDependencyGraphPlugin$autoImport$;
import ch.epfl.scala.SubmitDependencyGraph$;
import ch.epfl.scala.githubapi.Manifest;
import gigahorse.FullResponse;
import gigahorse.HttpClient;
import gigahorse.Request;
import gigahorse.support.asynchttpclient.Gigahorse$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Paths;
import sbt.Command;
import sbt.Command$;
import sbt.State;
import sbt.State$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.MessageOnlyException;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.Parser$;
import sbt.internal.util.complete.Parsers$;
import sbt.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import sjsonnew.shaded.scalajson.ast.unsafe.JArray;
import sjsonnew.shaded.scalajson.ast.unsafe.JField;
import sjsonnew.shaded.scalajson.ast.unsafe.JObject;
import sjsonnew.shaded.scalajson.ast.unsafe.JString;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;

public final class AnalyzeDependencyGraph$ {
    public static AnalyzeDependencyGraph$ MODULE$;
    private HttpClient http;
    private final String help;
    private final String AnalyzeDependencies;
    private final String AnalyzeDependenciesUsage;
    private final String AnalyzeDependenciesDetail;
    private final Seq<Command> commands;
    private volatile boolean bitmap$0;

    static {
        new AnalyzeDependencyGraph$();
    }

    public String help() {
        return this.help;
    }

    public String AnalyzeDependencies() {
        return this.AnalyzeDependencies;
    }

    private String AnalyzeDependenciesUsage() {
        return this.AnalyzeDependenciesUsage;
    }

    private String AnalyzeDependenciesDetail() {
        return this.AnalyzeDependenciesDetail;
    }

    public Seq<Command> commands() {
        return this.commands;
    }

    private Parser<AnalyzeDependencyGraph.AnalysisParams> parser(State state) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parsers$.MODULE$.any()).$times()).map((Function1 & Serializable & scala.Serializable)raw -> {
            String string;
            Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])raw.mkString().trim().split(" "))).toSeq();
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && "".equals(string = (String)((SeqLike)some.get()).apply(0)) ? true : Nil$.MODULE$.equals(seq)) {
                return new AnalyzeDependencyGraph.AnalysisParams((Option<String>)None$.MODULE$);
            }
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                String arg = (String)((SeqLike)some2.get()).apply(0);
                return new AnalyzeDependencyGraph.AnalysisParams((Option<String>)new Some((Object)arg));
            }
            throw new MatchError((Object)seq);
        })).failOnException();
    }

    private State analyzeDependencies(State state, AnalyzeDependencyGraph.AnalysisParams params) {
        params.repository().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getGitHubRepo()).flatMap((Function1 & Serializable & scala.Serializable)repo -> {
            Some some;
            Try<Seq<AnalyzeDependencyGraph.Vulnerability>> try_ = MODULE$.downloadAlerts(state, (String)repo);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Seq v = (Seq)success.value();
                some = new Some((Object)v);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Failed to download alerts: ").append(e.getMessage()).toString());
                some = None$.MODULE$;
            } else {
                throw new MatchError(try_);
            }
            return some.map((Function1 & Serializable & scala.Serializable)vulnerabilities -> {
                AnalyzeDependencyGraph$.MODULE$.analyzeCves(state, (Seq<AnalyzeDependencyGraph.Vulnerability>)vulnerabilities);
                return BoxedUnit.UNIT;
            });
        });
        return state;
    }

    private void analyzeCves(State state, Seq<AnalyzeDependencyGraph.Vulnerability> vulnerabilities) {
        Seq<String> artifacts = this.getAllArtifacts(state);
        vulnerabilities.foreach((Function1 & Serializable & scala.Serializable)v -> {
            AnalyzeDependencyGraph$.$anonfun$analyzeCves$1(artifacts, v);
            return BoxedUnit.UNIT;
        });
    }

    private <T> Option<T> getStateOrWarn(State state, AttributeKey<T> key, String what, String command) {
        return State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), key).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("\ud83d\udfe0 No ").append(what).append(" found, please run '").append(command).append("' first").toString());
            return None$.MODULE$;
        });
    }

    private Try<Seq<AnalyzeDependencyGraph.Vulnerability>> downloadAlerts(State state, String repo) {
        String snapshotUrl = new StringBuilder(47).append("https://api.github.com/repos/").append(repo).append("/dependabot/alerts").toString();
        Request request = Gigahorse$.MODULE$.url(snapshotUrl).get().addHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Authorization"), (Object)new StringBuilder(6).append("token ").append(this.getGithubToken()).toString())}));
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Downloading alerts from ").append(snapshotUrl).toString());
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (FullResponse)Await$.MODULE$.result((Awaitable)MODULE$.http().processFull(request), (Duration)Duration$.MODULE$.Inf())).flatMap((Function1 & Serializable & scala.Serializable)httpResp -> MODULE$.getVulnerabilities((FullResponse)httpResp).map((Function1 & Serializable & scala.Serializable)vulnerabilities -> {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Downloaded ").append(vulnerabilities.size()).append(" alerts").toString());
            return vulnerabilities;
        }));
    }

    private HttpClient http$lzycompute() {
        AnalyzeDependencyGraph$ analyzeDependencyGraph$ = this;
        synchronized (analyzeDependencyGraph$) {
            if (!this.bitmap$0) {
                this.http = Gigahorse$.MODULE$.http(Gigahorse$.MODULE$.config());
                this.bitmap$0 = true;
            }
        }
        return this.http;
    }

    private HttpClient http() {
        if (!this.bitmap$0) {
            return this.http$lzycompute();
        }
        return this.http;
    }

    public Seq<Map<String, Manifest>> getGithubManifest(State state) {
        return Option$.MODULE$.option2Iterable(this.getStateOrWarn(state, GithubDependencyGraphPlugin$autoImport$.MODULE$.githubManifestsKey(), "dependencies", SubmitDependencyGraph$.MODULE$.Generate())).toSeq();
    }

    private Option<String> getGithubTokenFromFile(File ghConfigFile) {
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Extract token from ").append(ghConfigFile.getPath()).toString());
        if (ghConfigFile.exists()) {
            return package$.MODULE$.IO().readLines(ghConfigFile, package$.MODULE$.IO().readLines$default$2()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("oauth_token"))).map((Function1 & Serializable & scala.Serializable)x$3 -> ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split(":"))).last()).trim());
        }
        return None$.MODULE$;
    }

    private String getGithubToken() {
        String ghConfigDir = Properties$.MODULE$.envOrElse("GH_CONFIG_DIR", ((Object)Paths.get(System.getProperty("user.home"), ".config", "gh")).toString());
        File ghConfigFile = Paths.get(ghConfigDir, new String[0]).resolve("hosts.yml").toFile();
        return (String)this.getGithubTokenFromFile(ghConfigFile).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String ghConfigPath = Properties$.MODULE$.envOrElse("HUB_CONFIG", ((Object)Paths.get(System.getProperty("user.home"), ".config", "hub")).toString());
            File hubConfigFile = Paths.get(ghConfigPath, new String[0]).toFile();
            return (String)MODULE$.getGithubTokenFromFile(hubConfigFile).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.githubToken());
        });
    }

    private Seq<String> getAllArtifacts(State state) {
        return (Seq)((SeqLike)this.getGithubManifest(state).flatMap((Function1 & Serializable & scala.Serializable)manifests -> (Iterable)manifests.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Manifest manifest = (Manifest)tuple2._2();
                return (Seq)manifest.resolved().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.package_url(), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    private String translateToSemVer(String string) {
        return string.replaceAll("([a-zA-Z]+)", "0").replaceAll("([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)", "$1.$2.$3-$4");
    }

    private boolean versionMatchesRange(String versionStr, String rangeStr) {
        String range = rangeStr.replaceAll(" ", "").replace(",", " ");
        return package$.MODULE$.VersionNumber().apply(this.translateToSemVer(versionStr)).matchesSemVer(package$.MODULE$.SemanticSelector().apply(this.translateToSemVer(range)));
    }

    private Tuple2<Seq<String>, Seq<String>> vulnerabilityMatchesArtifacts(AnalyzeDependencyGraph.Vulnerability alert, Seq<String> artifacts) {
        String alertMavenPath = new StringBuilder(11).append("pkg:maven/").append(alert.packageId().replace(":", "/")).append("@").toString();
        return ((TraversableLike)artifacts.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(alertMavenPath)))).partition((Function1 & Serializable & scala.Serializable)artifact -> BoxesRunTime.boxToBoolean((boolean)AnalyzeDependencyGraph$.$anonfun$vulnerabilityMatchesArtifacts$2(alert, artifact)));
    }

    public Option<String> getGitHubRepo() {
        String string;
        String remoteUrl = scala.sys.process.package$.MODULE$.stringToProcess("git config --get remote.origin.url").$bang$bang().trim();
        Regex repoPattern = new StringOps(Predef$.MODULE$.augmentString("(?:https://|git@)github\\.com[:/](.+/.+)\\.git")).r();
        Option option = repoPattern.unapplySeq((CharSequence)(string = remoteUrl));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String repo = (String)((LinearSeqOptimized)option.get()).apply(0);
            return new Some((Object)repo);
        }
        return None$.MODULE$;
    }

    private Try<Seq<AnalyzeDependencyGraph.Vulnerability>> getVulnerabilities(FullResponse httpResp) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n = httpResp.status();
            switch (n) {
                default: 
            }
            if (n / 100 == 2) {
                JArray json = (JArray)sjsonnew.support.scalajson.unsafe.Parser$.MODULE$.parseFromByteBuffer(httpResp.bodyAsByteBuffer()).get();
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])json.value())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends JValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        JObject jObject;
                        A1 A1 = x1;
                        if (A1 instanceof JObject && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(jObject = (JObject)A1).value())).collectFirst((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends JField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 != null) {
                                    JString jString;
                                    String string;
                                    String string2 = A1.field();
                                    JValue jValue = A1.value();
                                    if ("state".equals(string2) && jValue instanceof JString && "open".equals(string = (jString = (JString)jValue).value())) {
                                        return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                                    }
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(JField x1) {
                                JField jField = x1;
                                if (jField != null) {
                                    JString jString;
                                    String string;
                                    String string2 = jField.field();
                                    JValue jValue = jField.value();
                                    if ("state".equals(string2) && jValue instanceof JString && "open".equals(string = (jString = (JString)jValue).value())) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        }).isDefined()) {
                            JField[] securityVulnerability = ((JObject)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jObject.value())).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    A1 A1 = x2;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue secVuln = A1.value();
                                        if ("security_vulnerability".equals(string) && secVuln instanceof JObject) {
                                            JObject jObject = (JObject)secVuln;
                                            return (B1)jObject;
                                        }
                                    }
                                    return (B1)function1.apply(x2);
                                }

                                public final boolean isDefinedAt(JField x2) {
                                    JField jField = x2;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue secVuln = jField.value();
                                        if ("security_vulnerability".equals(string) && secVuln instanceof JObject) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).get()).value();
                            JField[] packageObj = ((JObject)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])securityVulnerability)).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                    A1 A1 = x3;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue pkg = A1.value();
                                        if ("package".equals(string) && pkg instanceof JObject) {
                                            JObject jObject = (JObject)pkg;
                                            return (B1)jObject;
                                        }
                                    }
                                    return (B1)function1.apply(x3);
                                }

                                public final boolean isDefinedAt(JField x3) {
                                    JField jField = x3;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue pkg = jField.value();
                                        if ("package".equals(string) && pkg instanceof JObject) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).get()).value();
                            String firstPatchedVersion = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])securityVulnerability)).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                                    A1 A1 = x4;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue firstPatched = A1.value();
                                        if ("first_patched_version".equals(string) && firstPatched instanceof JObject) {
                                            JObject jObject = (JObject)firstPatched;
                                            return (B1)jObject;
                                        }
                                    }
                                    return (B1)function1.apply(x4);
                                }

                                public final boolean isDefinedAt(JField x4) {
                                    JField jField = x4;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue firstPatched = jField.value();
                                        if ("first_patched_version".equals(string) && firstPatched instanceof JObject) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).map((Function1 & Serializable & scala.Serializable)x$6 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.value())).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                                    A1 A1 = x5;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue jValue = A1.value();
                                        if ("identifier".equals(string) && jValue instanceof JString) {
                                            JString jString = (JString)jValue;
                                            String ident = jString.value();
                                            return (B1)ident;
                                        }
                                    }
                                    return (B1)function1.apply(x5);
                                }

                                public final boolean isDefinedAt(JField x5) {
                                    JField jField = x5;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue jValue = jField.value();
                                        if ("identifier".equals(string) && jValue instanceof JString) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            return (B1)new AnalyzeDependencyGraph.Vulnerability((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])packageObj)).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                                    A1 A1 = x6;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue jValue = A1.value();
                                        if ("name".equals(string) && jValue instanceof JString) {
                                            JString jString = (JString)jValue;
                                            String name = jString.value();
                                            return (B1)name;
                                        }
                                    }
                                    return (B1)function1.apply(x6);
                                }

                                public final boolean isDefinedAt(JField x6) {
                                    JField jField = x6;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue jValue = jField.value();
                                        if ("name".equals(string) && jValue instanceof JString) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).get(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])securityVulnerability)).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                                    A1 A1 = x7;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue jValue = A1.value();
                                        if ("vulnerable_version_range".equals(string) && jValue instanceof JString) {
                                            JString jString = (JString)jValue;
                                            String range = jString.value();
                                            return (B1)range;
                                        }
                                    }
                                    return (B1)function1.apply(x7);
                                }

                                public final boolean isDefinedAt(JField x7) {
                                    JField jField = x7;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue jValue = jField.value();
                                        if ("vulnerable_version_range".equals(string) && jValue instanceof JString) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).get(), firstPatchedVersion, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])securityVulnerability)).collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends JField, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                                    A1 A1 = x8;
                                    if (A1 != null) {
                                        String string = A1.field();
                                        JValue jValue = A1.value();
                                        if ("severity".equals(string) && jValue instanceof JString) {
                                            JString jString = (JString)jValue;
                                            String sev = jString.value();
                                            return (B1)sev;
                                        }
                                    }
                                    return (B1)function1.apply(x8);
                                }

                                public final boolean isDefinedAt(JField x8) {
                                    JField jField = x8;
                                    if (jField != null) {
                                        String string = jField.field();
                                        JValue jValue = jField.value();
                                        if ("severity".equals(string) && jValue instanceof JString) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }
                            }).get());
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(JValue x1) {
                        JObject jObject;
                        JValue jValue = x1;
                        return jValue instanceof JObject && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(jObject = (JObject)jValue).value())).collectFirst((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends JField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 != null) {
                                    JString jString;
                                    String string;
                                    String string2 = A1.field();
                                    JValue jValue = A1.value();
                                    if ("state".equals(string2) && jValue instanceof JString && "open".equals(string = (jString = (JString)jValue).value())) {
                                        return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                                    }
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(JField x1) {
                                JField jField = x1;
                                if (jField != null) {
                                    JString jString;
                                    String string;
                                    String string2 = jField.field();
                                    JValue jValue = jField.value();
                                    if ("state".equals(string2) && jValue instanceof JString && "open".equals(string = (jString = (JString)jValue).value())) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        }).isDefined();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(sjsonnew.shaded.scalajson.ast.unsafe.JObject ), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$3()}, serializedLambda);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AnalyzeDependencyGraph.Vulnerability.class))))).toSeq();
            }
            String message = new StringBuilder(31).append("Unexpected status ").append(httpResp.status()).append(" ").append(httpResp.statusText()).append(" with body:\n").append(httpResp.bodyAsString()).toString();
            throw new MessageOnlyException(message);
        });
    }

    private String githubToken() {
        return Properties$.MODULE$.envOrElse("GITHUB_TOKEN", "");
    }

    public static final /* synthetic */ void $anonfun$analyzeCves$1(Seq artifacts$1, AnalyzeDependencyGraph.Vulnerability v) {
        Tuple2<Seq<String>, Seq<String>> tuple2 = MODULE$.vulnerabilityMatchesArtifacts(v, (Seq<String>)artifacts$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq badMatches = (Seq)tuple2._1();
        Seq goodMatches = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)badMatches, (Object)goodMatches);
        Seq badMatches2 = (Seq)tuple22._1();
        Seq goodMatches2 = (Seq)tuple22._2();
        Predef$.MODULE$.println((Object)v.toString());
        if (goodMatches2.nonEmpty() || badMatches2.nonEmpty()) {
            goodMatches2.foreach((Function1 & Serializable & scala.Serializable)m -> {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("    \ud83d\udfe2 ").append(m.replaceAll(".*@", "")).toString());
                return BoxedUnit.UNIT;
            });
            badMatches2.foreach((Function1 & Serializable & scala.Serializable)m -> {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("    \ud83d\udd34 ").append(m.replaceAll(".*@", "")).toString());
                return BoxedUnit.UNIT;
            });
            return;
        }
        Predef$.MODULE$.println((Object)"    \ud83c\udf89 no match (dependency was probably removed)");
    }

    public static final /* synthetic */ boolean $anonfun$vulnerabilityMatchesArtifacts$2(AnalyzeDependencyGraph.Vulnerability alert$1, String artifact) {
        String version = artifact.replaceAll(".*@", "");
        return MODULE$.versionMatchesRange(version, alert$1.vulnerableVersionRange());
    }

    private AnalyzeDependencyGraph$() {
        MODULE$ = this;
        this.help = "download and display CVEs alerts from Github, and analyze them against dependencies (use hub or gh local config or GIT_TOKEN env var to authenticate, requires githubGenerateSnapshot)";
        this.AnalyzeDependencies = "githubAnalyzeDependencies";
        this.AnalyzeDependenciesUsage = new StringBuilder(10).append(this.AnalyzeDependencies()).append(" [pattern]").toString();
        this.AnalyzeDependenciesDetail = new StringBuilder(57).append("Analyze the dependencies based on a search pattern:\n  ").append(this.help()).append("\n  ").toString();
        this.commands = (Seq)new .colon.colon((Object)Command$.MODULE$.apply(this.AnalyzeDependencies(), new Tuple2((Object)this.AnalyzeDependenciesUsage(), (Object)this.AnalyzeDependenciesDetail()), this.AnalyzeDependenciesDetail(), (Function1 & Serializable & scala.Serializable)state -> MODULE$.parser((State)state), (Function2 & Serializable & scala.Serializable)(state, params) -> MODULE$.analyzeDependencies((State)state, (AnalyzeDependencyGraph.AnalysisParams)params)), (List)Nil$.MODULE$);
    }
}

