/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticOption {
    private static Logger LOG = LoggerFactory.getLogger(StaticOption.class);
    private static Map<String, Pair<Type, Object[]>> optionsDefinitions = Maps.newLinkedHashMap();
    private static Map<String, Pair<Type, Object>> choosenOption = Maps.newLinkedHashMap();
    private static int maxCombinaisonIndex = Integer.MIN_VALUE;

    public static void parseOptions(List<String> optionsStr) {
        maxCombinaisonIndex = 1;
        for (int i = 0; i < optionsStr.size(); ++i) {
            int j;
            Object[] optionsValues;
            String[] split = optionsStr.get(i).split(" ");
            Preconditions.checkArgument((split.length > 1 ? 1 : 0) != 0, (Object)("Param o" + i + " should have at least paramName{space}paramType"));
            Preconditions.checkArgument((split.length < 99 ? 1 : 0) != 0, (Object)("Param o" + i + ": too many options"));
            String name = split[0];
            String type = split[1];
            if (type.equals(Type.bool.name())) {
                optionsDefinitions.put(name, (Pair<Type, Object[]>)new Pair((Object)Type.bool, (Object)new Object[]{true, false}));
                maxCombinaisonIndex *= 2;
                LOG.info("static option '{}' ('o{}') with type '{}' added", new Object[]{name, i + 1, type});
                continue;
            }
            if (type.equals(Type.integer.name())) {
                optionsValues = new Object[split.length - 2];
                for (j = 2; j < split.length; ++j) {
                    optionsValues[j - 2] = Integer.parseInt(split[j]);
                }
                optionsDefinitions.put(name, (Pair<Type, Object[]>)new Pair((Object)Type.integer, (Object)optionsValues));
                maxCombinaisonIndex *= optionsValues.length;
                LOG.info("static option '{}' ('o{}') with type '{}' added with options '{}'", new Object[]{name, i + 1, type, StringUtils.join((Object[])optionsValues, (String)", ")});
                continue;
            }
            if (type.equals(Type.dble.name())) {
                optionsValues = new Object[split.length - 2];
                for (j = 2; j < split.length; ++j) {
                    optionsValues[j - 2] = Double.parseDouble(split[j]);
                }
                optionsDefinitions.put(name, (Pair<Type, Object[]>)new Pair((Object)Type.dble, (Object)optionsValues));
                maxCombinaisonIndex *= optionsValues.length;
                LOG.info("static option '{}' ('o{}') with type '{}' added with options '{}'", new Object[]{name, i + 1, type, StringUtils.join((Object[])optionsValues, (String)", ")});
                continue;
            }
            if (type.equals(Type.string.name())) {
                optionsValues = new Object[split.length - 2];
                for (j = 2; j < split.length; ++j) {
                    optionsValues[j - 2] = split[j];
                }
                optionsDefinitions.put(name, (Pair<Type, Object[]>)new Pair((Object)Type.string, (Object)optionsValues));
                maxCombinaisonIndex *= optionsValues.length;
                LOG.info("static option '{}' ('o{}') with type '{}' added with options '{}'", new Object[]{name, i + 1, type, StringUtils.join((Object[])optionsValues, (String)" ,")});
                continue;
            }
            throw new IllegalArgumentException("no paramType " + type);
        }
    }

    public static Map<String, Pair<Type, Object>> setChoosenOption(int combinaisonIndex) {
        int ci = combinaisonIndex;
        int totalCombinaisons = 1;
        for (Pair<Type, Object[]> pair : optionsDefinitions.values()) {
            totalCombinaisons *= ((Object[])pair.getValue()).length;
        }
        if (ci > totalCombinaisons) {
            throw new IllegalArgumentException("combinaisonIndex too large, max is " + (totalCombinaisons - 1));
        }
        for (Map.Entry entry : optionsDefinitions.entrySet()) {
            String name = (String)entry.getKey();
            Type type = (Type)((Object)((Pair)entry.getValue()).getKey());
            Object[] options = (Object[])((Pair)entry.getValue()).getValue();
            int l = totalCombinaisons / options.length;
            int whichBin = ci / l;
            ci %= l;
            totalCombinaisons /= options.length;
            choosenOption.put(name, (Pair<Type, Object>)new Pair((Object)type, options[whichBin]));
        }
        return choosenOption;
    }

    public static Pair<Type, Object[]> getOptionDefinition(String name) {
        return optionsDefinitions.get(name);
    }

    public static void print() {
        String msg = "choosen static options: ";
        for (Map.Entry<String, Pair<Type, Object>> e : choosenOption.entrySet()) {
            msg = msg + e.getKey() + "::" + e.getValue().getValue() + " ";
        }
        LOG.info(msg);
    }

    public static void reset() {
        optionsDefinitions = Maps.newLinkedHashMap();
        choosenOption = Maps.newLinkedHashMap();
    }

    public static int getMaxCombinaisonIndex() {
        return maxCombinaisonIndex;
    }

    public static Object get(String key, Type type) {
        if (!choosenOption.containsKey(key)) {
            throw new IllegalArgumentException("no key " + key);
        }
        Pair<Type, Object> pair = choosenOption.get(key);
        if (((Type)((Object)pair.getKey())).equals((Object)type)) {
            return pair.getValue();
        }
        throw new IllegalArgumentException("key " + key + " has wrong type: " + pair.getKey());
    }

    public static boolean getBoolean(String key) {
        return (Boolean)StaticOption.get(key, Type.bool);
    }

    public static void setBoolean(String key, boolean value) {
        choosenOption.put(key, (Pair<Type, Object>)new Pair((Object)Type.bool, (Object)value));
    }

    public static int getInt(String key) {
        return (Integer)StaticOption.get(key, Type.integer);
    }

    public static void setInt(String key, int value) {
        choosenOption.put(key, (Pair<Type, Object>)new Pair((Object)Type.integer, (Object)value));
    }

    public static double getDouble(String key) {
        return (Double)StaticOption.get(key, Type.dble);
    }

    public static void setDouble(String key, double value) {
        choosenOption.put(key, (Pair<Type, Object>)new Pair((Object)Type.dble, (Object)value));
    }

    public static String getString(String key) {
        return (String)StaticOption.get(key, Type.string);
    }

    public static void setString(String key, String value) {
        choosenOption.put(key, (Pair<Type, Object>)new Pair((Object)Type.string, (Object)value));
    }

    public static void parseConfiguration(List<String> optionsStr) {
        for (String configParameter : optionsStr) {
            String[] split = configParameter.split(" ");
            Preconditions.checkArgument((split.length > 1 ? 1 : 0) != 0, (Object)("Param " + configParameter + " should have the format paramName{space}paramType{space}value"));
            Preconditions.checkArgument((split.length <= 3 ? 1 : 0) != 0, (Object)("Param " + configParameter + " should have the format paramName{space}paramType{space}value"));
            String name = split[0];
            String type = split[1];
            String value = split[2];
            LOG.info("static option '{}' of type '{}' set to value '{}'", new Object[]{name, type, value});
            if (type.equals(Type.bool.name())) {
                StaticOption.setBoolean(name, value.equals("true"));
                continue;
            }
            if (type.equals(Type.integer.name())) {
                StaticOption.setInt(name, Integer.parseInt(value));
                continue;
            }
            if (type.equals(Type.dble.name())) {
                StaticOption.setDouble(name, Double.parseDouble(value));
                continue;
            }
            if (type.equals(Type.string.name())) {
                StaticOption.setString(name, value);
                continue;
            }
            throw new IllegalArgumentException("no paramType " + type);
        }
    }

    public static enum Type {
        bool,
        integer,
        dble,
        string;

    }
}

