/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.Keep;
import ch.epfl.bbp.uima.types.Measure;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Keep"}, outputs={"ch.epfl.bbp.uima.types.Keep"})
public class MeasureNormalizerAnnotator
extends JCasAnnotator_ImplBase {
    public static final String MEASURE_MASK = "MEASURE___";
    private static final Object MEASURE_DATE = "Date";
    public static final String PARAM_REMOVE_SIMPLE_MEASURE = "removeSimpleMeasure";
    @ConfigurationParameter(name="removeSimpleMeasure", defaultValue={"false"}, description="Remove measures which are single numbers (MEASURE_)")
    private boolean removeMeasure;
    public static final String PARAM_REMOVE_DATE_MEASURE = "removeDateMeasure";
    @ConfigurationParameter(name="removeDateMeasure", defaultValue={"false"}, description="Remove measures which are single numbers (MEASURE_Date)")
    private boolean removeDates;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Keep[] keeps = JCasUtil.select((JCas)jCas, Keep.class).toArray(new Keep[0]);
        for (int i = 0; i < keeps.length; ++i) {
            Keep k = keeps[i];
            Annotation a = k.getEnclosedAnnot();
            if (!(a instanceof Measure)) continue;
            String unit = ((Measure)a).getUnit();
            if (unit == null) {
                if (this.removeMeasure) {
                    k.removeFromIndexes(jCas);
                    continue;
                }
                k.setNormalizedText(MEASURE_MASK);
                continue;
            }
            if (unit.isEmpty() && this.removeMeasure) {
                k.removeFromIndexes(jCas);
                continue;
            }
            if (unit.equals(MEASURE_DATE) && this.removeDates) {
                k.removeFromIndexes(jCas);
                continue;
            }
            k.setNormalizedText(MEASURE_MASK + unit);
        }
    }
}

