/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.Keep;
import ch.epfl.bbp.uima.typesystem.TypeSystemSemantics;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Keep"}, outputs={"ch.epfl.bbp.uima.types.Keep"})
public class LeaveOnlyKeepsEnclosedAnnotationsAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashSet annotsToKeepIndex = Sets.newHashSet();
        for (Keep k : JCasUtil.select((JCas)jCas, Keep.class)) {
            annotsToKeepIndex.add(k.getEnclosedAnnot().getAddress());
        }
        ArrayList toDelete = Lists.newArrayList();
        for (Annotation a : jCas.getAnnotationIndex()) {
            if (TypeSystemSemantics.NON_CONTENT_ANNOTATIONS.contains(a.getClass().getName()) || annotsToKeepIndex.contains(a.getAddress())) continue;
            toDelete.add(a);
        }
        Annotation[] arr = toDelete.toArray(new Annotation[toDelete.size()]);
        for (int i = 0; i < arr.length; ++i) {
            arr[i].removeFromIndexes(jCas);
        }
    }
}

