/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Keep;
import de.julielab.jules.types.Sentence;
import java.util.Collection;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class KeepsDumper
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="printCoveredText", defaultValue={"false"}, description="Prints the covered text of every Keep")
    private boolean printCoveredText;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String pmID = null;
        String keepText = null;
        pmID = BlueCasUtil.getHeaderDocId(jCas);
        System.out.println("Doc " + pmID + " --------------------------------------------");
        Map sentences = JCasUtil.indexCovered((JCas)jCas, Sentence.class, Keep.class);
        for (Sentence s : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Keep k : (Collection)sentences.get(s)) {
                keepText = k.getNormalizedText().replace(' ', '_');
                if (this.printCoveredText) {
                    keepText = keepText + "[" + k.getCoveredText() + "]";
                }
                System.out.print(keepText + " ");
            }
            System.out.println();
        }
        System.out.println();
    }
}

