/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.io.LineReader;
import ch.epfl.bbp.uima.utils.Preconditions;
import de.julielab.jules.types.Header;
import java.io.File;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class OneDocPerLineReader3
extends JCasCollectionReader_ImplBase {
    @ConfigurationParameter(name="inputDirectory", description="path to directory")
    protected String inputDir;
    @ConfigurationParameter(name="between", description="specifies a range of pubmed_id, e.g. {13,17} --> 13 <= pubmed_id <= 17. It is recommended to keep it under 1M, as these results are all stored in the db memory")
    private int[] between;
    private int nextPmid;
    private int lastPmid;
    private String nextTxt = "";

    public void initialize(UimaContext context) throws ResourceInitializationException {
        Preconditions.checkFileExists(this.inputDir);
        Preconditions.checkEquals(2, this.between.length);
        com.google.common.base.Preconditions.checkArgument((this.between[0] < this.between[1] ? 1 : 0) != 0);
        this.nextPmid = this.between[0] - 1;
        this.lastPmid = this.between[1];
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        Header header = new Header(jcas);
        header.setDocId("" + this.nextPmid);
        header.addToIndexes();
        jcas.setDocumentText(this.nextTxt);
    }

    public boolean hasNext() throws IOException, CollectionException {
        while (true) {
            ++this.nextPmid;
            if (this.nextPmid > this.lastPmid) {
                return false;
            }
            File nextFile = new File(this.inputDir + "/" + this.nextPmid + ".tsv");
            if (!nextFile.exists()) continue;
            this.nextTxt = LineReader.asText((File)nextFile).split("\t")[1];
            if (this.nextTxt.trim().length() != 0) break;
        }
        return true;
    }

    public Progress[] getProgress() {
        return null;
    }
}

