/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Cooccurrence;
import java.util.Collection;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class FilterCoocurrencesByDistance
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(FilterCoocurrencesByDistance.class);
    public static final String PARAM_MAXIMUM_DISTANCE = "maximumDistance";
    @ConfigurationParameter(name="maximumDistance", mandatory=true, description="the maximum distance between the 2 entities of that co-occurrence")
    protected int maximumDistance;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection coocs = JCasUtil.select((JCas)jCas, Cooccurrence.class);
        Cooccurrence[] array = coocs.toArray(new Cooccurrence[coocs.size()]);
        for (int i = 0; i < array.length; ++i) {
            if (BlueCasUtil.distance(array[i].getFirstEntity(), array[i].getSecondEntity()) <= this.maximumDistance) continue;
            array[i].removeFromIndexes();
        }
    }
}

