/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.StringUtils;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Cooccurrence;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
@TypeCapability(outputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class ExtractCoocurrences
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(ExtractCoocurrences.class);
    @ConfigurationParameter(name="enclosingScope", defaultValue={"de.julielab.jules.types.Sentence"}, mandatory=false, description="the enclosing scope to iterate on and extract co-occurrence from. Defaults to sentences")
    protected String enclosingScopeStr;
    protected Class<? extends Annotation> enclosingScope;
    @ConfigurationParameter(name="annot1", description="the first annotation to extract co-occurrences from")
    protected String annotationStr1;
    protected Class<? extends Annotation> annotation1;
    @ConfigurationParameter(name="annot1IdField", defaultValue={"coveredText"}, description="The name of the annotation field to get the entity id from. Uses coveredText as default to get the text of the annotation itself.Note that one can add multiple fields separated by commas.")
    protected String firstIdFieldsRaw;
    protected String[] firstIdFields;
    protected List<Method> firstIdMethods = new ArrayList<Method>();
    @ConfigurationParameter(name="annot2", description="the second annotation to extract co-occurrences from")
    protected String annotationStr2;
    protected Class<? extends Annotation> annotation2;
    @ConfigurationParameter(name="annot2IdField", defaultValue={"coveredText"}, description="the name of the annotation field to get the entity id from. Uses coveredText as default to get the text of the annotation itself.Note that one can add multiple fields separated by commas.")
    protected String secondIdFieldsRaw;
    protected String[] secondIdFields;
    protected List<Method> secondIdMethods = new ArrayList<Method>();
    @ConfigurationParameter(name="cooccurrenceType", defaultValue={""}, description="A string to distinguish the co-occurrence.")
    protected String cooccurrenceType;
    public static final String PARAM_KEEP_ONLY_NEAREST_NEIGHBORS = "keepOnlyNearestNeighbors";
    @ConfigurationParameter(name="keepOnlyNearestNeighbors", defaultValue={"false"}, description="keep only one co-occurrence per entity based on the distance between the two elements of the co-occurrence")
    protected boolean keepOnlyNearestNeighbors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.firstIdFields = this.firstIdFieldsRaw.split(",");
            this.secondIdFields = this.secondIdFieldsRaw.split(",");
            this.enclosingScope = Class.forName(this.enclosingScopeStr);
            this.annotation1 = Class.forName(this.annotationStr1);
            this.annotation2 = Class.forName(this.annotationStr2);
            this.firstIdMethods = ExtractCoocurrences.validateFields(this.firstIdFields, this.annotation1);
            this.secondIdMethods = ExtractCoocurrences.validateFields(this.secondIdFields, this.annotation2);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashMap annotToDistance = Maps.newHashMap();
        HashMap annotationToCoOccurrence = Maps.newHashMap();
        for (Annotation enclosingAnnot : JCasUtil.select((JCas)jCas, this.enclosingScope)) {
            List<Annotation> annots1 = BlueCasUtil.asList(JCasUtil.subiterate((JCas)jCas, this.annotation1, (AnnotationFS)enclosingAnnot, (boolean)true, (boolean)false));
            List<Annotation> annots2 = BlueCasUtil.asList(JCasUtil.subiterate((JCas)jCas, this.annotation2, (AnnotationFS)enclosingAnnot, (boolean)true, (boolean)false));
            if (annots1 == null || annots2 == null || annots1.isEmpty() || annots2.isEmpty()) continue;
            for (Annotation a1 : annots1) {
                for (Annotation a2 : annots2) {
                    if (BlueCasUtil.haveSameBeginEnd(a1, a2)) continue;
                    String[] firstIdValues = ExtractCoocurrences.getValues(this.firstIdMethods, a1);
                    String[] secondIdValues = ExtractCoocurrences.getValues(this.secondIdMethods, a2);
                    if (this.keepOnlyNearestNeighbors) {
                        int oldDistanceForFirstAnnot = Integer.MAX_VALUE;
                        int oldDistanceForSecondAnnot = Integer.MAX_VALUE;
                        int distanceBetweenAnnot = BlueCasUtil.distance(a1, a2);
                        if (distanceBetweenAnnot == -1) continue;
                        if (annotToDistance.containsKey(a1)) {
                            oldDistanceForFirstAnnot = (Integer)annotToDistance.get(a1);
                        }
                        if (annotToDistance.containsKey(a2)) {
                            oldDistanceForSecondAnnot = (Integer)annotToDistance.get(a2);
                        }
                        if (distanceBetweenAnnot >= oldDistanceForFirstAnnot || distanceBetweenAnnot >= oldDistanceForSecondAnnot) continue;
                        this.removeExistingCooccurrences(annotationToCoOccurrence, a1, a2);
                        annotToDistance.put(a1, distanceBetweenAnnot);
                        annotToDistance.put(a2, distanceBetweenAnnot);
                        Cooccurrence cooc = this.filterCooccurence(jCas, enclosingAnnot, a1, a2, firstIdValues, secondIdValues);
                        if (cooc != null) {
                            annotationToCoOccurrence.put(a1, cooc);
                            annotationToCoOccurrence.put(a2, cooc);
                            continue;
                        }
                        LOG.warn("a null co-occurrences happens");
                        continue;
                    }
                    this.filterCooccurence(jCas, enclosingAnnot, a1, a2, firstIdValues, secondIdValues);
                }
            }
        }
    }

    protected Cooccurrence filterCooccurence(JCas jCas, Annotation enclosingAnnot, Annotation annot1, Annotation annot2, String[] firstIds, String[] secondIds) {
        Cooccurrence cooccurence = new Cooccurrence(jCas, Math.min(annot1.getBegin(), annot2.getBegin()), Math.max(annot1.getEnd(), annot2.getEnd()));
        cooccurence.setFirstEntity(annot1);
        cooccurence.setSecondEntity(annot2);
        cooccurence.setFirstIds(ExtractCoocurrences.convertToStringArray(jCas, firstIds));
        cooccurence.setSecondIds(ExtractCoocurrences.convertToStringArray(jCas, secondIds));
        cooccurence.setSnippetBegin(enclosingAnnot.getBegin());
        cooccurence.setSnippetEnd(enclosingAnnot.getEnd());
        cooccurence.setCooccurrenceType(this.cooccurrenceType);
        cooccurence.addToIndexes();
        return cooccurence;
    }

    private void removeExistingCooccurrences(Map<Annotation, Cooccurrence> savedCoOccurrences, Annotation a1, Annotation a2) {
        if (savedCoOccurrences.containsKey(a1)) {
            savedCoOccurrences.get(a1).removeFromIndexes();
            savedCoOccurrences.remove(a1);
        }
        if (savedCoOccurrences.containsKey(a2)) {
            savedCoOccurrences.get(a2).removeFromIndexes();
            savedCoOccurrences.remove(a2);
        }
    }

    static List<Method> validateFields(String[] idFields, Class<? extends Annotation> annotationClass) {
        LinkedList idMethods = Lists.newLinkedList();
        for (String idField : idFields) {
            Method idMethod = null;
            for (Method m : annotationClass.getMethods()) {
                if (!m.getName().equals("get" + org.apache.commons.lang3.StringUtils.capitalize((String)idField.trim())) || m.getParameterTypes().length != 0) continue;
                idMethod = m;
            }
            if (idMethod == null) {
                throw new RuntimeException(idField + " field for annot " + annotationClass.getCanonicalName() + " not found");
            }
            idMethods.add(idMethod);
        }
        return idMethods;
    }

    static String[] getValues(List<Method> methods, Annotation onAnnotation) {
        LinkedList<String> ids = new LinkedList<String>();
        for (Method method : methods) {
            try {
                Object callResult = method.invoke((Object)onAnnotation, new Object[0]);
                if (callResult instanceof StringArray) {
                    StringArray strArray = (StringArray)callResult;
                    for (String str : strArray.toStringArray()) {
                        ids.add(str);
                    }
                    continue;
                }
                if (callResult == null) {
                    ids.add("NULL");
                    continue;
                }
                ids.add(callResult.toString().replaceAll("[\t\n]", " "));
            }
            catch (Exception e) {
                throw new RuntimeException("could not get idstring " + method.getName() + ", " + StringUtils.print((Throwable)e));
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    static StringArray convertToStringArray(JCas cas, String[] nativeStrArray) {
        int arrayLength = nativeStrArray.length;
        StringArray strArray = new StringArray(cas, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            strArray.set(i, nativeStrArray[i]);
        }
        return strArray;
    }
}

