/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.uima.BlueCasUtil;
import com.google.common.collect.Lists;
import de.julielab.jules.types.Sentence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class PrintAnnotationInSentenceWriter
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputFile", mandatory=false, description="outputfile, or null for sysout")
    private String outputFile;
    private boolean htmlOutput = false;
    @ConfigurationParameter(name="annotationClass", mandatory=true, description="the full name of the annotation class")
    private String annotationClassName;
    private Class<? extends Annotation> annotationClass;
    private PrintWriter writer;
    private String startTag = "{{";
    private String endTag = "}}";

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.writer = this.outputFile == null || this.outputFile.equals("null") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedWriter(new FileWriter(new File(this.outputFile))));
            if (this.htmlOutput) {
                this.startTag = "<span class=\"an\">";
                this.endTag = "</span>";
                this.writer.append("<html><head><style>.an {color:black;background:lightgreen;}</style></head><body>\n");
            } else {
                this.writer.append("pmid:sentenceId\ttxt\n");
            }
            this.annotationClass = Class.forName(this.annotationClassName);
        }
        catch (ClassNotFoundException e1) {
            throw new ResourceInitializationException((Throwable)new Exception("Could not load class for Sentence " + this.annotationClassName));
        }
        catch (Exception e) {
            throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{this.outputFile}, (Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String pmid = BlueCasUtil.getHeaderDocId(jcas);
        try {
            int sentenceId = 0;
            for (Sentence s : JCasUtil.select((JCas)jcas, Sentence.class)) {
                String txt = s.getCoveredText();
                ArrayList annots = Lists.newArrayList((Iterable)JCasUtil.selectCovered(this.annotationClass, (AnnotationFS)s));
                if (!annots.isEmpty()) {
                    for (Annotation a : Lists.reverse((List)annots)) {
                        int begin = a.getBegin() - s.getBegin();
                        int end = a.getEnd() - s.getBegin();
                        txt = txt.substring(0, begin) + this.startTag + a.getCoveredText() + this.endTag + txt.substring(end);
                    }
                    txt.replaceAll("\\r\\n|\\r|\\n", " ").replaceAll(" +", " ");
                    if (this.htmlOutput) {
                        this.writer.append("<p><a href=\"http://www.ncbi.nlm.nih.gov/pubmed/" + pmid + "\">" + pmid + "[" + sentenceId + "]</a> " + txt + "</p>\n");
                    } else {
                        this.writer.append(pmid + ":" + sentenceId + "\t" + txt + "\n");
                    }
                }
                ++sentenceId;
            }
            this.writer.flush();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        if (this.htmlOutput) {
            this.writer.append("</body></html>");
        }
        IOUtils.closeQuietly((Writer)this.writer);
    }
}

