/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationTypeWriter
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(AnnotationTypeWriter.class);
    @ConfigurationParameter(name="outputFile", defaultValue={"out.txt"}, description="outputfile, or System for sysout")
    protected String outputFile;
    @ConfigurationParameter(name="annotationClass", defaultValue={"org.apache.uima.jcas.tcas.Annotation"}, description="the full name of the annotation class")
    protected String annotationClass;
    @ConfigurationParameter(name="featureName", description="the name of the feature to extract, or none for the text only", mandatory=false)
    protected String featureName;
    public static final String PARAM_FILTER_FEATURES_WITH_VALUE = "filterFeaturesWithValue";
    @ConfigurationParameter(name="filterFeaturesWithValue", description="filter the features that have this value", mandatory=false)
    protected String filterFeaturesWithValue;
    private static final String PARAM_NEW_LINE = "param_new_line";
    @ConfigurationParameter(name="param_new_line", description="whether to add a new line after each token", defaultValue={"true"}, mandatory=false)
    protected boolean newLine;
    protected PrintWriter writer;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.writer = this.outputFile.equals("System") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedWriter(new FileWriter(new File(this.outputFile))));
        }
        catch (Exception e) {
            throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{this.outputFile}, (Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            for (Annotation annotation : jcas.getAnnotationIndex()) {
                if (!annotation.getType().getName().equals(this.annotationClass)) continue;
                LOG.trace("printing " + annotation.getCoveredText());
                if (this.featureName != null) {
                    Feature feature = annotation.getType().getFeatureByBaseName(this.featureName);
                    String featureStr = annotation.getFeatureValueAsString(feature);
                    if (this.filterFeaturesWithValue != null && featureStr.equals(this.filterFeaturesWithValue)) continue;
                    this.writer.append(annotation.getCoveredText() + "<" + featureStr + ">");
                    if (this.newLine) {
                        this.writer.println();
                        continue;
                    }
                    this.writer.append(" ");
                    continue;
                }
                this.writer.append(annotation.getCoveredText());
                if (this.newLine) {
                    this.writer.println();
                    continue;
                }
                this.writer.append(" ");
            }
            this.writer.flush();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        IOUtils.closeQuietly((Writer)this.writer);
    }
}

