/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class KeepLargestAnnotationAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="annotationClass", mandatory=true, description="the full name of the annotation class")
    private String annotationClassStr;
    private Class<? extends Annotation> annotationClass;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.annotationClass = Class.forName(this.annotationClassStr);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        ArrayList annots = new ArrayList(JCasUtil.select((JCas)jcas, this.annotationClass));
        if (annots.size() > 1) {
            HashSet toDelete = Sets.newHashSet();
            for (int i = 0; i < annots.size(); ++i) {
                Annotation outer = (Annotation)annots.get(i);
                if (toDelete.contains(outer)) continue;
                toDelete.addAll(JCasUtil.selectCovered(this.annotationClass, (AnnotationFS)outer));
            }
            Annotation[] arr = toDelete.toArray(new Annotation[toDelete.size()]);
            for (int i = 0; i < arr.length; ++i) {
                arr[i].removeFromIndexes(jcas);
            }
        }
    }
}

