/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.io.LineReader;
import ch.epfl.bbp.uima.BlueUima;
import ch.epfl.bbp.uima.types.GeneralEnglish;
import ch.epfl.bbp.uima.utils.Preconditions;
import de.julielab.jules.types.Token;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"de.julielab.jules.types.Token"}, outputs={"ch.epfl.bbp.uima.types.GeneralEnglish"})
public class GeneralEnglishAnnotator
extends JCasAnnotator_ImplBase {
    private List<String> generalEnglish;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            String dict = BlueUima.BLUE_UTILS_ROOT + "src/main/resources/" + "generalEnglish/basic_english.txt";
            Preconditions.checkFileExists(dict);
            this.generalEnglish = LineReader.linesFrom((String)dict);
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Token t : JCasUtil.select((JCas)jCas, Token.class)) {
            String text = t.getCoveredText().trim();
            if (text.length() <= 0 || !this.generalEnglish.contains(text)) continue;
            new GeneralEnglish(jCas, t.getBegin(), t.getEnd()).addToIndexes();
        }
    }
}

