/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;

public class GarbageCollectorAnnotator
extends JCasAnnotator_ImplBase {
    private static final Runtime s_runtime = Runtime.getRuntime();
    public static final String RUN_EVERY_N_DOCUMENTS = "runEveryNDocument";
    @ConfigurationParameter(name="runEveryNDocument", description="", defaultValue={"10000"})
    private int runEveryNDocument;
    private long counter = 0L;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (this.counter++ % (long)this.runEveryNDocument == 0L) {
            try {
                GarbageCollectorAnnotator.runGC();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void runGC() {
        for (int r = 0; r < 4; ++r) {
            GarbageCollectorAnnotator._runGC();
        }
    }

    private static void _runGC() {
        long usedMem1 = GarbageCollectorAnnotator.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.currentThread();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = GarbageCollectorAnnotator.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }

    public static long freeMemory() {
        return s_runtime.freeMemory();
    }

    public static long maxMemory() {
        return s_runtime.maxMemory();
    }
}

