/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.validation.TestEvaluator;
import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class EvaluationAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="gold_annotation", mandatory=true, description="the annotation class name to copy to the gold view (and remove from initial view")
    private String goldAnnotationStr;
    private Class<? extends Annotation> goldAnnotation;
    @ConfigurationParameter(name="system_annotation", mandatory=true, description="the annotation class name to copy to the gold view (and remove from initial view")
    private String systemAnnotationStr;
    private Class<? extends Annotation> systemAnnotation;
    @ConfigurationParameter(name="evaluator", defaultValue={"exact"}, description="possible values: atLeastCovered, atLeastCovering, exact, overlap")
    private String evaluatorType;
    TestEvaluator<Annotation, Annotation> evaluator;
    @ConfigurationParameter(name="verbose", mandatory=false, defaultValue={"true"}, description="whether to print verbose logs")
    private boolean verbose;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.goldAnnotation = Class.forName(this.goldAnnotationStr);
            this.systemAnnotation = Class.forName(this.systemAnnotationStr);
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
        if (this.evaluatorType.equals("atLeastCovered")) {
            this.evaluator = TestEvaluator.getAtLeastCoveredEvaluator();
        } else if (this.evaluatorType.equals("atLeastCovering")) {
            this.evaluator = TestEvaluator.getAtLeastCoveringEvaluator();
        } else if (this.evaluatorType.equals("overlap")) {
            this.evaluator = TestEvaluator.getOverlapEvaluator();
        } else if (this.evaluatorType.equals("exact")) {
            this.evaluator = TestEvaluator.getExactEvaluator();
        } else {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("not a valid parameter for 'evaluator': " + this.evaluatorType));
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas systemView;
        JCas goldView;
        try {
            goldView = jCas.getView("view_gold");
            systemView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        Collection goldAnnot = JCasUtil.select((JCas)goldView, this.goldAnnotation);
        Collection systAnnot = JCasUtil.select((JCas)systemView, this.systemAnnotation);
        if (this.verbose) {
            System.out.println("comparing #gold:" + goldAnnot.size() + " #sys:" + systAnnot.size() + " [pmid " + BlueCasUtil.getHeaderDocId(jCas) + "]");
        }
        String log = this.evaluator.add(goldAnnot, systAnnot, "");
        if (this.verbose) {
            System.out.println(log);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        System.out.println(this.goldAnnotation.getSimpleName() + "<-->" + this.systemAnnotation.getSimpleName() + " [" + this.evaluatorType + "] " + this.evaluator.compare());
    }
}

