/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.validation;

import ch.epfl.bbp.uima.ae.serialization.BinaryCasReader;
import ch.epfl.bbp.uima.utils.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class CrossvalidationReader
extends JCasCollectionReader_ImplBase {
    Logger LOG = LoggerFactory.getLogger(CrossvalidationReader.class);
    @ConfigurationParameter(name="corpusName")
    private String corpusName;
    @ConfigurationParameter(name="maxNrResults")
    private int maxDocs;
    public static final String PARAM_SEED = "seed";
    @ConfigurationParameter(name="seed", defaultValue={"17"})
    private int seed;
    public static final String PARAM_SPLITS = "splits";
    @ConfigurationParameter(name="splits", defaultValue={"10"})
    private int splitsCnt;
    public static final String PARAM_SLICE = "slice";
    @ConfigurationParameter(name="slice", description="which slice of the above split")
    private int slice;
    public static final String PARAM_MODE_EVAL = "modeEval";
    @ConfigurationParameter(name="modeEval", description="true => eval (=returns 1 slice for eval); false => train (=returns e.g. 9 slices for training)  ")
    private boolean modeEval;
    private File store;
    private Iterator<Integer> corpusIt;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        com.google.common.base.Preconditions.checkArgument((this.maxDocs > 0 ? 1 : 0) != 0, (Object)"maxDocs should be >> 0");
        this.store = new File("target/crossvalidation_" + this.corpusName);
        if (!this.store.exists()) {
            throw new RuntimeException("no corpus exists at " + this.store.getPath());
        }
        this.LOG.warn("reading Cross-Validation data in {}", (Object)this.store.getPath());
        try {
            ArrayList ids = Lists.newArrayList();
            for (int i = 0; i < this.maxDocs; ++i) {
                ids.add(i);
            }
            Collections.shuffle(ids, new Random(this.seed));
            int splitsSize = (int)Math.ceil(((double)this.maxDocs + 0.0) / ((double)this.splitsCnt + 0.0));
            List splits = Lists.partition((List)ids, (int)splitsSize);
            ArrayList corpus = Lists.newArrayList();
            if (this.modeEval) {
                corpus.addAll((Collection)splits.get(this.slice));
            } else {
                for (int i = 0; i < splits.size(); ++i) {
                    if (i == this.slice) continue;
                    corpus.addAll((Collection)splits.get(i));
                }
            }
            this.LOG.warn("using {} docs", (Object)corpus.size());
            this.corpusIt = corpus.iterator();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.corpusIt.hasNext();
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        Integer docId = this.corpusIt.next();
        File file = new File(this.store, docId + ".gz");
        Preconditions.checkFileExists(file);
        try {
            BinaryCasReader.deserialize(file, jCas);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Progress[] getProgress() {
        return null;
    }
}

