/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class StructuredDirectory {
    public static int[] getSplit(int docId) {
        if (docId <= 0) {
            throw new IllegalArgumentException("docId must be positive");
        }
        int[] ret = new int[]{docId / 1000000, docId % 1000000 / 1000, docId % 1000};
        return ret;
    }

    public static File storeFile(File outDir, File inputFile) throws IOException {
        int docId = Integer.parseInt(FilenameUtils.removeExtension((String)inputFile.getName()));
        int[] paths = StructuredDirectory.getSplit(docId);
        FileUtils.forceMkdir((File)outDir);
        File dir1 = new File(outDir, paths[0] + "");
        FileUtils.forceMkdir((File)dir1);
        File dir2 = new File(dir1, paths[1] + "");
        FileUtils.forceMkdir((File)dir2);
        String newFileName = paths[2] + "." + FilenameUtils.getExtension((String)inputFile.getName());
        File newFile = new File(dir2, newFileName);
        FileUtils.copyFile((File)inputFile, (File)newFile);
        return newFile;
    }

    public static int decodeFileName(File inputFile) throws IOException {
        try {
            int ret = Integer.parseInt(FilenameUtils.removeExtension((String)inputFile.getName()));
            ret += 1000 * Integer.parseInt(inputFile.getParentFile().getName());
            return ret += 1000000 * Integer.parseInt(inputFile.getParentFile().getParentFile().getName());
        }
        catch (Throwable t) {
            throw new IOException("could not decode filename, make sure it looks like somepath/12/345/678.txt", t);
        }
    }

    public static int decodeFileName(String inputFile) throws IOException {
        String[] split = inputFile.split("/");
        Preconditions.checkArgument((split.length == 3 ? 1 : 0) != 0);
        try {
            int ret = Integer.parseInt(FilenameUtils.removeExtension((String)split[2]));
            ret += 1000 * Integer.parseInt(split[1]);
            return ret += 1000000 * Integer.parseInt(split[0]);
        }
        catch (Throwable t) {
            throw new IOException("could not decode filename, make sure it looks like somepath/12/345/678.txt", t);
        }
    }

    public static String getFilePath(int docId, String extention) {
        int[] split = StructuredDirectory.getSplit(docId);
        return split[0] + "/" + split[1] + "/" + split[2] + "." + extention;
    }
}

