/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.Keep;
import java.util.Collection;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class KeepsCleaner
extends JCasAnnotator_ImplBase {
    private final int minLength = 3;
    private static final String PARAM_TRANSFORM_LOWERCASE = "transformLowercase";
    @ConfigurationParameter(name="transformLowercase", mandatory=false, defaultValue={"true"}, description="Whether to transform lowercase all the Keep's getNormalizedText()")
    private boolean transformLowercase;
    private static final Pattern onlyPunctAndNumbers = Pattern.compile("^(?:\\p{Punct}|\\d)+$");

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection col = JCasUtil.select((JCas)jCas, Keep.class);
        Keep[] keeps = col.toArray(new Keep[col.size()]);
        for (int i = 0; i < keeps.length; ++i) {
            String txt = keeps[i].getNormalizedText();
            if (txt.length() < 3 || !KeepsCleaner.isBalanced(txt) || txt.startsWith("www.") || KeepsCleaner.isOnlyPunctAndNumbers(txt)) {
                keeps[i].removeFromIndexes();
                continue;
            }
            if (this.transformLowercase) {
                txt = txt.toLowerCase();
            }
            keeps[i].setNormalizedText(txt.replaceAll("^\\W+|\\W+$", ""));
        }
    }

    public static boolean isOnlyPunctAndNumbers(String txt) {
        return onlyPunctAndNumbers.matcher(txt).matches();
    }

    public static boolean isBalanced(String expression) {
        int LEFT_NORMAL = 40;
        int RIGHT_NORMAL = 41;
        int LEFT_CURLY = 123;
        int RIGHT_CURLY = 125;
        int LEFT_SQUARE = 91;
        int RIGHT_SQUARE = 93;
        Stack<Character> stack = new Stack<Character>();
        boolean failed = false;
        block6: for (int i = 0; !failed && i < expression.length(); ++i) {
            switch (expression.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    stack.push(Character.valueOf(expression.charAt(i)));
                    continue block6;
                }
                case ')': {
                    if (!stack.isEmpty() && ((Character)stack.pop()).charValue() == '(') continue block6;
                    failed = true;
                    continue block6;
                }
                case '}': {
                    if (!stack.isEmpty() && ((Character)stack.pop()).charValue() == '{') continue block6;
                    failed = true;
                    continue block6;
                }
                case ']': {
                    if (!stack.isEmpty() && ((Character)stack.pop()).charValue() == '[') continue block6;
                    failed = true;
                }
            }
        }
        return stack.isEmpty() && !failed;
    }
}

