/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.triechar.TrieCnt;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Keep;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Keep"}, outputs={})
public class FrequencyFilterWriter
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="caseSensitive", defaultValue={"false"}, description="If true, tokens are not normalized to lowercase before string comparisions")
    private boolean caseSensitive;
    @ConfigurationParameter(name="outputFile", description="Where to write frequency file")
    private String tokenFrequencyFile;
    private TrieCnt trie;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.trie = new TrieCnt(this.caseSensitive);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (BlueCasUtil.keepDoc(jCas)) {
            for (Keep keep : JCasUtil.select((JCas)jCas, Keep.class)) {
                this.trie.addWord(keep.getNormalizedText().replace(' ', '_'));
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.trie.toFrequencyFile(this.tokenFrequencyFile);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

