/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.io.LineReader;
import ch.epfl.bbp.uima.utils.Preconditions;
import de.julielab.jules.types.Header;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class OneDocPerLineReader
extends JCasCollectionReader_ImplBase {
    @ConfigurationParameter(name="inputFile", description="path to text file")
    protected String inputFile;
    protected Iterator<String> textFileReader;
    protected String nextLine;
    protected int pmId = 1;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            Preconditions.checkFileExists(this.inputFile);
            this.textFileReader = new LineReader((InputStream)new FileInputStream(this.inputFile)).iterator();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        String[] split = this.nextLine.split("\t");
        Header header = new Header(jcas);
        if (split.length == 2) {
            header.setDocId(split[0]);
            jcas.setDocumentText(split[1]);
        } else {
            header.setDocId(this.pmId++ + "_generated");
            jcas.setDocumentText(this.nextLine);
        }
        header.addToIndexes();
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.hasNextLine();
    }

    private boolean hasNextLine() {
        if (this.textFileReader.hasNext()) {
            this.nextLine = this.textFileReader.next();
            if (this.nextLine.startsWith("#")) {
                return this.hasNextLine();
            }
            return true;
        }
        return false;
    }

    public Progress[] getProgress() {
        return null;
    }
}

