/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.ae.relations.CooccurrencesEvaluationAnnotator;
import ch.epfl.bbp.uima.ae.relations.WriteCoocurrencesToLoadfile2;
import ch.epfl.bbp.uima.types.BrainRegionDictTerm;
import ch.epfl.bbp.uima.types.Cooccurrence;
import ch.epfl.bbp.uima.utils.LoadDataFileWriter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
public class WriteCoocurrencesToLoadfile3
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(WriteCoocurrencesToLoadfile3.class);
    private static final String VIEW1 = "topdown";
    private static final String VIEW2 = "kernel";
    private static final String VIEW3 = "rules";
    private static final boolean DEBUG = false;
    @ConfigurationParameter(name="outputFile", mandatory=true)
    protected String outputFile;
    @ConfigurationParameter(name="verbose", defaultValue={"true"}, mandatory=false, description="Whether to write the snippet text.")
    protected boolean writeSnippet;
    protected LoadDataFileWriter writer;
    protected int cooccCnt = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            LOG.info("writing LOAD DATA file to {}", (Object)this.outputFile);
            this.writer = new LoadDataFileWriter(new File(this.outputFile), "\t");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int pmId = BlueCasUtil.getHeaderIntDocId(jCas);
        try {
            JCas view1 = jCas.getView(VIEW1);
            JCas view2 = jCas.getView(VIEW2);
            JCas view3 = jCas.getView(VIEW3);
            Collection first = JCasUtil.select((JCas)view1, Cooccurrence.class);
            Collection second = JCasUtil.select((JCas)view2, Cooccurrence.class);
            Collection third = JCasUtil.select((JCas)view3, Cooccurrence.class);
            LinkedList union = Lists.newLinkedList();
            for (Cooccurrence c : first) {
                if (CooccurrencesEvaluationAnnotator.contains(union, c)) continue;
                union.add(c);
            }
            for (Cooccurrence c : second) {
                if (CooccurrencesEvaluationAnnotator.contains(union, c)) continue;
                union.add(c);
            }
            for (Cooccurrence c : third) {
                if (CooccurrencesEvaluationAnnotator.contains(union, c)) continue;
                union.add(c);
            }
            for (Cooccurrence c : union) {
                this.write(jCas, pmId, c, CooccurrencesEvaluationAnnotator.contains(first, c), CooccurrencesEvaluationAnnotator.contains(second, c), CooccurrencesEvaluationAnnotator.contains(third, c));
            }
        }
        catch (Exception e) {
            LOG.error("something went wrong with " + pmId, (Throwable)e);
        }
    }

    private void write(JCas jCas, int pmId, Cooccurrence c, boolean sys1, boolean sys2, boolean sys3) throws AnalysisEngineProcessException {
        ArrayList lines = Lists.newArrayList();
        lines.add(pmId);
        lines.add(Float.valueOf(c.getConfidence()));
        lines.add(c.getFirstEntity().getCoveredText().replaceAll("[\r\t\n]", ""));
        lines.add(((BrainRegionDictTerm)c.getFirstEntity()).getEntityId());
        lines.add(c.getFirstEntity().getBegin());
        lines.add(c.getFirstEntity().getEnd());
        lines.add(c.getSecondEntity().getCoveredText().replaceAll("[\r\t\n]", ""));
        lines.add(((BrainRegionDictTerm)c.getSecondEntity()).getEntityId());
        lines.add(c.getSecondEntity().getBegin());
        lines.add(c.getSecondEntity().getEnd());
        lines.add(sys1 ? "1" : "0");
        lines.add(sys2 ? "1" : "0");
        lines.add(sys3 ? "1" : "0");
        lines.add(c.getSnippetBegin());
        lines.add(c.getSnippetEnd());
        if (this.writeSnippet) {
            String snippet = WriteCoocurrencesToLoadfile2.snippet(jCas, c.getSnippetBegin(), c.getSnippetEnd(), c.getFirstEntity(), c.getSecondEntity());
            lines.add(snippet);
        }
        try {
            this.writer.addLoadLine(lines.toArray());
        }
        catch (Exception e) {
            LOG.warn("could not write Coocs for pmId " + pmId, (Throwable)e);
        }
        if (this.cooccCnt++ % 50 == 0) {
            try {
                LOG.debug("flushing at coocc\t{}", (Object)this.cooccCnt);
                this.writer.flush();
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

