/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Cooccurrence;
import ch.epfl.bbp.uima.typesystem.To;
import ch.epfl.bbp.uima.utils.LoadDataFileWriter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
public class WriteCoocurrencesToLoadfile2
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(WriteCoocurrencesToLoadfile2.class);
    private static final String NULL = "NULL";
    @ConfigurationParameter(name="outputFile", mandatory=true)
    protected String outputFile;
    @ConfigurationParameter(name="annot1Type", mandatory=false, defaultValue={"NULL"}, description="an optional id (String, int, whatever) to identify the type of the first annotation.")
    protected String annot1Type;
    @ConfigurationParameter(name="annot2Type", mandatory=false, defaultValue={"NULL"}, description="an optional id (String, int, whatever) to identify the type of the second annotation.")
    protected String annot2Type;
    @ConfigurationParameter(name="cooccurrenceType", mandatory=false, description="Whether to filter on a given type of cooccurrence. If none provided, selects ALL cooccurrences.")
    protected String cooccurrenceType;
    @ConfigurationParameter(name="verbose", defaultValue={"true"}, mandatory=false, description="Whether to write the snippet text.")
    protected boolean writeSnippet;
    protected LoadDataFileWriter writer;
    protected int cooccCnt = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            LOG.info("writing LOAD DATA file to {}", (Object)this.outputFile);
            this.writer = new LoadDataFileWriter(new File(this.outputFile), "\t");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int pmId = BlueCasUtil.getHeaderIntDocId(jCas);
        for (Cooccurrence c : JCasUtil.select((JCas)jCas, Cooccurrence.class)) {
            String line;
            if (this.cooccurrenceType != null && !c.getCooccurrenceType().equals(this.cooccurrenceType)) continue;
            ArrayList lines = Lists.newArrayList();
            lines.add(pmId);
            lines.add(Float.valueOf(c.getConfidence()));
            for (String firstId : c.getFirstIds().toArray()) {
                line = firstId == null ? NULL : firstId.replaceAll("[\r\t\n]", "");
                lines.add(line);
            }
            lines.add(c.getFirstEntity().getBegin());
            lines.add(c.getFirstEntity().getEnd());
            if (!this.annot1Type.equals(NULL)) {
                lines.add(this.annot1Type);
            }
            for (String secondId : c.getSecondIds().toArray()) {
                line = secondId == null ? NULL : secondId.replaceAll("[\r\t\n]", "");
                lines.add(line);
            }
            lines.add(c.getSecondEntity().getBegin());
            lines.add(c.getSecondEntity().getEnd());
            if (!this.annot2Type.equals(NULL)) {
                lines.add(this.annot2Type);
            }
            lines.add(c.getSnippetBegin());
            lines.add(c.getSnippetEnd());
            if (this.writeSnippet) {
                String snippet = WriteCoocurrencesToLoadfile2.snippet(jCas, c.getSnippetBegin(), c.getSnippetEnd(), c.getFirstEntity(), c.getSecondEntity());
                lines.add(snippet);
            }
            try {
                this.writer.addLoadLine(lines.toArray());
            }
            catch (Exception e) {
                LOG.warn("could not write Coocs '" + this.annot1Type + "'<-->'" + this.annot2Type + "' for pmId " + pmId, (Throwable)e);
            }
            if (this.cooccCnt++ % 50 != 0) continue;
            try {
                LOG.debug("flushing at coocc\t{}", (Object)this.cooccCnt);
                this.writer.flush();
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static String snippet(JCas jCas, int snippetBegin, int snippetEnd, Annotation a1, Annotation a2) {
        String s;
        String T_BEGIN = "<strong class=\"";
        String T_END = "</strong>";
        String sError = s = jCas.getDocumentText().substring(snippetBegin, snippetEnd);
        try {
            int relA1Begin = a1.getBegin() - snippetBegin;
            int relA1End = a1.getEnd() - snippetBegin;
            int relA2Begin = a2.getBegin() - snippetBegin;
            int relA2End = a2.getEnd() - snippetBegin;
            BlueCasUtil.Position position = BlueCasUtil.isBefore(a1, a2);
            if (position == BlueCasUtil.Position.before) {
                s = s.substring(0, relA2End) + "</strong>" + s.substring(relA2End);
                s = s.substring(0, relA2Begin) + "<strong class=\"" + a2.getClass().getSimpleName() + "\">" + s.substring(relA2Begin);
                s = s.substring(0, relA1End) + "</strong>" + s.substring(relA1End);
                s = s.substring(0, relA1Begin) + "<strong class=\"" + a1.getClass().getSimpleName() + "\">" + s.substring(relA1Begin);
            } else if (position == BlueCasUtil.Position.after) {
                s = s.substring(0, relA1End) + "</strong>" + s.substring(relA1End);
                s = s.substring(0, relA1Begin) + "<strong class=\"" + a1.getClass().getSimpleName() + "\">" + s.substring(relA1Begin);
                s = s.substring(0, relA2End) + "</strong>" + s.substring(relA2End);
                s = s.substring(0, relA2Begin) + "<strong class=\"" + a2.getClass().getSimpleName() + "\">" + s.substring(relA2Begin);
            } else {
                LOG.warn("don't know how to highlight snippet that overlaps '{}' and '{}', pmid:{}" + BlueCasUtil.getHeaderDocId(jCas), (Object)a1.getCoveredText(), (Object)a2.getCoveredText());
            }
            return s.replaceAll("[\r\t\n]", "");
        }
        catch (Exception e) {
            LOG.warn("Could not extract snippet on pmid {} beg {} end {} a1 {} a2 {}", new Object[]{BlueCasUtil.getHeaderDocId(jCas), snippetBegin, snippetEnd, To.string((Object)a1), To.string((Object)a2)});
            return sError;
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        LOG.debug("TOTAL cooccurrences\t{}\t[{}]", (Object)this.cooccCnt, (Object)this.cooccurrenceType);
    }
}

