/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Cooccurrence;
import ch.epfl.bbp.uima.utils.LoadDataFileWriter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
public class WriteCoocurrencesToLoadfile
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(WriteCoocurrencesToLoadfile.class);
    public static final String[] FIELDS = new String[]{"pubmed_id", "annot_1_id", "annot_1_start", "annot_1_end", "annot_2_id", " annot_2_start", "annot_2_end"};
    @ConfigurationParameter(name="outputFile", mandatory=true)
    protected String outputFile;
    public static final String PARAM_WRITE_SNIPPETS = "writeSnippets";
    @ConfigurationParameter(name="writeSnippets", mandatory=false, defaultValue={"true"})
    protected boolean writeSnippets;
    protected LoadDataFileWriter writer;
    protected LoadDataFileWriter snippetWriter;
    protected int docCnt = 0;
    protected int cooccCnt = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            LOG.info("writing LOAD DATA file to {}", (Object)this.outputFile);
            this.writer = new LoadDataFileWriter(new File(this.outputFile), "\t", FIELDS);
            if (this.writeSnippets) {
                this.snippetWriter = new LoadDataFileWriter(new File(this.outputFile + ".snippet"), "\t");
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int pmId = BlueCasUtil.getHeaderIntDocId(jCas);
        for (Cooccurrence c : JCasUtil.select((JCas)jCas, Cooccurrence.class)) {
            ArrayList line = Lists.newArrayList();
            line.add(pmId);
            for (String firstId : c.getFirstIds().toArray()) {
                line.add(firstId.replaceAll("[\r\t\n]", ""));
            }
            line.add(c.getFirstEntity().getBegin());
            line.add(c.getFirstEntity().getEnd());
            for (String secondId : c.getSecondIds().toArray()) {
                line.add(secondId.replaceAll("[\r\t\n]", ""));
            }
            line.add(c.getSecondEntity().getBegin());
            line.add(c.getSecondEntity().getEnd());
            this.writer.addLoadLine(line.toArray());
            if (this.writeSnippets) {
                String snippet = jCas.getDocumentText().substring(c.getSnippetBegin(), c.getSnippetEnd()).replaceAll("[\r\t\n]", "");
                this.snippetWriter.addLoadLine(snippet);
            }
            ++this.cooccCnt;
        }
        if (++this.docCnt % 100 == 0) {
            try {
                LOG.debug("flushing at docCnt\t{}\tcoocc\t{}", (Object)this.docCnt, (Object)this.cooccCnt);
                this.writer.flush();
                if (this.writeSnippets) {
                    this.snippetWriter.flush();
                }
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.writer.close();
            if (this.writeSnippets) {
                this.snippetWriter.flush();
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        LOG.debug("TOTAL docCnt\t{}\tcoocc\t{}", (Object)this.docCnt, (Object)this.cooccCnt);
    }
}

