/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.uima.utils.StructuredDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.component.xwriter.HeaderDocIdFileNamer;
import org.apache.uima.fit.component.xwriter.XWriterFileNamer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

@OperationalProperties(multipleDeploymentAllowed=true)
public class ZipXWriter
extends JCasConsumer_ImplBase {
    @ConfigurationParameter(name="outputDir", mandatory=true, description="takes a path to directory into which output files will be written.")
    private String outputDirectoryName;
    public static final String PARAM_XML_SCHEME_NAME = "xmlSchemeName";
    @ConfigurationParameter(mandatory=true, defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' (default) and 'XCAS'.")
    private String xmlSchemeName;
    public static final String PARAM_FILE_NAMER_CLASS_NAME = "fileNamerClassName";
    @ConfigurationParameter(mandatory=true, description="the class name of the XWriterFileNamer implementation to use", defaultValue={"org.apache.uima.fit.component.xwriter.IntegerFileNamer"})
    protected String fileNamerClassName;
    public static final String PARAM_STRUCTURE_DIR = "dirStructure";
    @ConfigurationParameter(mandatory=false, description="whether to output in a structure directory", defaultValue={"false"})
    protected boolean dirStructure;
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    private File outputDirectory;
    private boolean useXMI = true;
    private XWriterFileNamer fileNamer;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (this.xmlSchemeName.equals(XMI)) {
            this.useXMI = true;
        } else if (this.xmlSchemeName.equals(XCAS)) {
            this.useXMI = false;
        } else {
            throw new ResourceInitializationException(String.format("parameter '%1$s' must be either '%2$s' or '%3$s'.", PARAM_XML_SCHEME_NAME, XMI, XCAS), null);
        }
        this.fileNamer = (XWriterFileNamer)InitializableFactory.create((UimaContext)context, (String)this.fileNamerClassName, XWriterFileNamer.class);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String fileName = this.fileNamer.nameFile(jcas);
        try {
            if (this.useXMI) {
                this.zipXmi(jcas.getCas(), fileName);
            } else {
                this.zipXCas(jcas.getCas(), fileName);
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipXCas(CAS aCas, String fileName) throws IOException, SAXException {
        File outFile = null;
        if (this.dirStructure) {
            outFile = new File(this.outputDirectory, StructuredDirectory.getFilePath(new Integer(fileName), "xcas.zip"));
            outFile.getParentFile().mkdirs();
        } else {
            outFile = new File(this.outputDirectory, fileName + ".xcas.zip");
        }
        FileOutputStream fos = null;
        try (ZipOutputStream zos = null;){
            fos = new FileOutputStream(outFile);
            zos = new ZipOutputStream(fos);
            zos.setLevel(9);
            ZipEntry ze = new ZipEntry(fileName + ".xmi");
            zos.putNextEntry(ze);
            XCASSerializer ser = new XCASSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)zos, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipXmi(CAS aCas, String id) throws IOException, SAXException {
        File outFile = null;
        if (this.dirStructure) {
            outFile = new File(this.outputDirectory, StructuredDirectory.getFilePath(new Integer(id), "xmi.zip"));
            outFile.getParentFile().mkdirs();
        } else {
            outFile = new File(this.outputDirectory, id + ".xmi.zip");
        }
        FileOutputStream fos = null;
        try (ZipOutputStream zos = null;){
            fos = new FileOutputStream(outFile);
            zos = new ZipOutputStream(fos);
            zos.setLevel(9);
            ZipEntry ze = new ZipEntry(id + ".xmi");
            zos.putNextEntry(ze);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)zos, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    public static AnalysisEngineDescription getAED(String outDir) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ZipXWriter.class, (Object[])new Object[]{"outputDir", outDir, PARAM_FILE_NAMER_CLASS_NAME, HeaderDocIdFileNamer.class.getName()});
    }
}

