/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.io.TextFileWriter;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.BlueUima;
import ch.epfl.bbp.uima.types.DocumentPage;
import ch.epfl.bbp.uima.typesystem.To;
import ch.epfl.bbp.uima.typesystem.TypeSystemSemantics;
import de.julielab.jules.types.Sentence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
@TypeCapability(inputs={"de.julielab.jules.types.Sentence", "de.julielab.jules.types.Token"})
public class BartWriter
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(BartWriter.class);
    public static final String PARAM_ADD_BRAT_FILES = "addBratFiles";
    @ConfigurationParameter(name="addBratFiles", defaultValue={"true"}, description="whether to add the complete, working brat server")
    private boolean addBratFiles;
    public static final String PARAM_BATCH_PREFIX = "batchPrefix";
    @ConfigurationParameter(name="batchPrefix", defaultValue={""}, description="prefix to add for each file in Brat; useful when comparing different batches")
    private String batchPrefix;
    public static final String PARAM_DEBUG = "debug";
    @ConfigurationParameter(name="debug", defaultValue={"false"}, description="prints out annotations to StdOut")
    private boolean debug;
    public static final String PARAM_WRITE_NOTES = "notes";
    @ConfigurationParameter(name="notes", defaultValue={"false"}, description="write notes (for hover)")
    private boolean writeNotes;
    public static final String SPLIT_PER_PAGE = "splitPerPage";
    @ConfigurationParameter(name="splitPerPage", defaultValue={"false"}, description="splits out Bart output per page")
    private boolean splitPerPage;
    @ConfigurationParameter(name="outputDir", defaultValue={"brat"}, mandatory=false)
    private String outputDir;
    private File dataDir;
    private int processedFiles = 0;
    private Set<String> annotationsSet = new HashSet<String>();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            File outputDirFile = new File(this.outputDir);
            FileUtils.forceMkdir((File)outputDirFile);
            if (this.addBratFiles) {
                FileUtils.copyDirectory((File)new File(BlueUima.BLUE_UTILS_ROOT + "src/main/resources/bart/brat-v1.3_Crunchy_Frog"), (File)outputDirFile);
                this.dataDir = new File(outputDirFile, "data");
            } else {
                this.dataDir = outputDirFile;
            }
            TextFileWriter textWriter = new TextFileWriter(this.dataDir + "/annotation.conf");
            textWriter.addLine("\n[entities]\n");
            for (String a : this.annotationsSet) {
                textWriter.addLine(a);
            }
            textWriter.addLine("\n[events]\n\n[relations]\n\n[attributes]\n\n");
            textWriter.close();
            FileUtils.copyFile((File)new File(BlueUima.BLUE_UTILS_ROOT + "src/main/resources/bart/visual.conf"), (File)new File(this.dataDir + "/visual.conf"));
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String pmId = BlueCasUtil.getHeaderDocId(jCas);
        try {
            if (this.splitPerPage) {
                Map indexPerPage = JCasUtil.indexCovered((JCas)jCas, DocumentPage.class, Annotation.class);
                for (Map.Entry page : indexPerPage.entrySet()) {
                    this.write(pmId, jCas, this.getOutDir() + pmId + "-p" + ((DocumentPage)page.getKey()).getPageId(), (Iterable)page.getValue());
                }
            } else {
                this.write(pmId, jCas, this.getOutDir() + pmId, (Iterable<Annotation>)jCas.getAnnotationIndex());
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        ++this.processedFiles;
    }

    private void write(String pmid, JCas jCas, String path, Iterable<Annotation> annotations) throws IOException {
        TextFileWriter textWriter = new TextFileWriter(path + ".txt");
        for (Annotation s : BlueCasUtil.filterStrict(annotations, Sentence.class)) {
            textWriter.addLine(s.getCoveredText());
        }
        textWriter.close();
        if (this.debug) {
            System.out.println("\nAnnotations for " + pmid);
        }
        BufferedWriter annotWriter = new BufferedWriter(new FileWriter(new File(path + ".ann")));
        int id = 0;
        String notes = "";
        for (Annotation a : annotations) {
            String aName = a.getClass().getName();
            if (TypeSystemSemantics.NON_CONTENT_ANNOTATIONS.contains(aName)) continue;
            try {
                this.annotationsSet.add(a.getClass().getSimpleName());
                String annotStr = "T" + id + "\t" + a.getClass().getSimpleName() + " " + a.getBegin() + " " + a.getEnd() + "\t" + a.getCoveredText() + "\n";
                if (this.debug) {
                    System.out.println(annotStr);
                }
                annotWriter.append(annotStr);
                notes = notes + "#" + id + "\tAnnotatorNotes T" + id + "\t" + To.string((Object)a) + "\n";
                ++id;
            }
            catch (Exception e) {
                LOG.warn("could not extract " + aName + " from " + pmid + " {}", (Object)e.getMessage());
            }
        }
        if (this.writeNotes) {
            annotWriter.append(notes);
        }
        annotWriter.close();
    }

    private String getOutDir() {
        int batchSuffix = this.processedFiles / 100;
        String outDir = this.dataDir + "/" + this.batchPrefix + "_" + batchSuffix + "/";
        new File(outDir).mkdirs();
        return outDir;
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.addBratFiles) {
            System.out.println("\n###############################################################################");
            System.out.println("BRAT annotation viewer\n");
            System.out.println("The BRAT server can be found at:\n" + this.outputDir + "\n");
            System.out.println("To start the standalone server, type\npython standalone.py");
            System.out.println("And then open your browser at http://localhost:8001/index.xhtml");
            System.out.println("Tutorial is here:\nhttp://localhost:8001/index.xhtml#/tutorials_bio/000-introduction");
            System.out.println("###############################################################################\n\n");
        }
    }
}

