/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class CopyAnnotationsAnnotator2
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="annotationClass", mandatory=true, description="annotation class name to copy")
    private String annotationStr;
    private Class<? extends Annotation> annotation;
    public static final String FROM_VIEW = "fromView";
    @ConfigurationParameter(name="fromView", mandatory=false, description="view name to copy from", defaultValue={"_InitialView"})
    private String fromViewStr;
    public static final String TO_VIEW = "toView";
    @ConfigurationParameter(name="toView", mandatory=true, description="view name to copy from")
    private String toViewStr;
    public static final String DELETE_FROM = "deleteFrom";
    @ConfigurationParameter(name="deleteFrom", defaultValue={"true"}, description="whether to delete the 'from' annotations (default), or leave them")
    private boolean deleteFrom;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.annotation = Class.forName(this.annotationStr);
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Annotation[] froms;
        JCas fromJCas = ViewCreatorAnnotator.createViewSafely((JCas)jCas, (String)this.fromViewStr);
        JCas toJCas = ViewCreatorAnnotator.createViewSafely((JCas)jCas, (String)this.toViewStr);
        Collection fromsCol = JCasUtil.select((JCas)fromJCas, this.annotation);
        for (Annotation from : froms = fromsCol.toArray(new Annotation[fromsCol.size()])) {
            CopyAnnotationsAnnotator2.copyAnnotationToView(from, toJCas);
        }
        if (this.deleteFrom) {
            for (int i = 0; i < froms.length; ++i) {
                froms[i].removeFromIndexes(fromJCas);
            }
        }
    }

    public static Annotation copyAnnotationToView(Annotation a, JCas view) {
        Annotation a2 = (Annotation)a.clone();
        Feature sofaFeature = a2.getType().getFeatureByBaseName("sofa");
        a2.setFeatureValue(sofaFeature, (FeatureStructure)view.getSofa());
        a2.addToIndexes(view);
        return a2;
    }
}

