/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima;

import ch.epfl.bbp.uima.types.TooFewTokensPerPage;
import ch.epfl.bbp.uima.types.TooManyOOV;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.julielab.jules.types.Header;
import de.julielab.jules.types.POSTag;
import de.julielab.jules.types.Sentence;
import de.julielab.jules.types.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasCreationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueCasUtil {
    private static Logger LOG = LoggerFactory.getLogger(BlueCasUtil.class);

    public static <T extends TOP> Collection<T> selectStrict(JCas jcas, Class<T> clasz, Class<?> strictClass) {
        Collection raw = JCasUtil.select((JCas)jcas, clasz);
        return BlueCasUtil.filterStrict(raw, strictClass);
    }

    public static boolean isEmptyText(JCas jCas) {
        return jCas.getDocumentText() == null || jCas.getDocumentText().length() == 0;
    }

    public static List<Annotation> findOverlapping(JCas jcas, Annotation annotIn) {
        ArrayList<Annotation> overlappings = new ArrayList<Annotation>();
        for (Annotation a : jcas.getAnnotationIndex()) {
            if (a.getBegin() != annotIn.getBegin() || a.getEnd() != annotIn.getEnd()) continue;
            overlappings.add(a);
        }
        return overlappings;
    }

    public static <T> Collection<T> filterStrict(Iterable<T> raw, Class<?> strictClass) {
        LinkedList<T> strict = new LinkedList<T>();
        for (T t : raw) {
            if (!t.getClass().equals(strictClass)) continue;
            strict.add(t);
        }
        return strict;
    }

    public static int getHeaderIntDocId(JCas jCas) {
        try {
            Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
            return Integer.parseInt(header.getDocId());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getHeaderDocId(JCas jCas) {
        try {
            Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
            return header.getDocId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHeaderSource(JCas jCas) {
        try {
            Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
            return header.getSource();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void fixNoSentences(JCas jCas) {
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        if (sentences.size() == 0) {
            String text = jCas.getDocumentText();
            Sentence sentence = new Sentence(jCas, 0, text.length());
            sentence.addToIndexes();
        }
    }

    public static void fixNoText(JCas jCas) {
        if (jCas.getDocumentText() == null) {
            jCas.setDocumentText("");
        }
    }

    public static String getSinglePosTag(Token t) {
        FSArray posTag = t.getPosTag();
        if (posTag != null && posTag.size() > 0) {
            return ((POSTag)posTag.get(0)).getValue();
        }
        return null;
    }

    public static Iterator<JCas> iterator(final CollectionReader cr) {
        return new Iterator<JCas>(){

            @Override
            public boolean hasNext() {
                try {
                    return cr.hasNext();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public JCas next() {
                try {
                    CAS cas = CasCreationUtils.createCas((ProcessingResourceMetaData)cr.getProcessingResourceMetaData());
                    cr.getNext(cas);
                    return cas.getJCas();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    public static ArrayList<JCas> asList(CollectionReader cr) {
        return Lists.newArrayList(BlueCasUtil.iterator(cr));
    }

    public static String inspect(JCas jcas, int begin, int end) {
        return BlueCasUtil.inspect(new Annotation(jcas, begin, end));
    }

    public static String inspect(Annotation a) {
        int begin = 40;
        int after = 50;
        try {
            JCas jCas = a.getCAS().getJCas();
            String text = jCas.getDocumentText();
            StringBuilder sb = new StringBuilder();
            if (a.getBegin() - 40 < 0) {
                for (int i = 0; i < 40 - a.getBegin(); ++i) {
                    sb.append(' ');
                }
                sb.append(text.substring(0, a.getBegin()));
            } else {
                sb.append(text.substring(a.getBegin() - 40, a.getBegin()));
            }
            sb.append('{');
            sb.append(a.getCoveredText());
            sb.append('}');
            if (a.getEnd() < text.length()) {
                sb.append(text.substring(a.getEnd(), Math.min(a.getEnd() + 50, text.length())));
            }
            sb.append("[pmid:" + BlueCasUtil.getHeaderIntDocId(jCas) + ", " + a.getBegin() + ":" + a.getEnd() + "]");
            return sb.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public static JCas setDocId(JCas jCas, int docId) {
        if (JCasUtil.exists((JCas)jCas, Header.class)) {
            throw new IllegalArgumentException();
        }
        Header h = new Header(jCas);
        h.setDocId(docId + "");
        h.addToIndexes();
        return jCas;
    }

    public static boolean haveSameBeginEnd(Annotation a, Annotation b) {
        return a.getBegin() == b.getBegin() && a.getEnd() == b.getEnd();
    }

    public static String getTitle(JCas jCas) {
        try {
            Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
            return header.getTitle();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<Annotation> selectCovered(CAS cas, AnnotationFS coveringAnnotation) {
        int begin = coveringAnnotation.getBegin();
        int end = coveringAnnotation.getEnd();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        FSIterator it = cas.getAnnotationIndex().iterator();
        it.moveTo((FeatureStructure)coveringAnnotation);
        if (!it.isValid()) {
            it.moveToLast();
            if (!it.isValid()) {
                return list;
            }
        }
        boolean moved = false;
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() >= begin) {
            it.moveToPrevious();
            moved = true;
        }
        if (moved) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            it.moveToFirst();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < begin) {
            it.moveToNext();
        }
        boolean strict = true;
        while (it.isValid()) {
            AnnotationFS a = (AnnotationFS)it.get();
            if (!(a instanceof Annotation)) continue;
            if (a.getBegin() > end) break;
            it.moveToNext();
            if (strict && a.getEnd() > end) continue;
            Preconditions.checkArgument((a.getBegin() >= coveringAnnotation.getBegin() ? 1 : 0) != 0, (Object)("Illegal begin " + a.getBegin() + " in [" + coveringAnnotation.getBegin() + ".." + coveringAnnotation.getEnd() + "]"));
            Preconditions.checkArgument((a.getEnd() <= coveringAnnotation.getEnd() ? 1 : 0) != 0, (Object)("Illegal end " + a.getEnd() + " in [" + coveringAnnotation.getBegin() + ".." + coveringAnnotation.getEnd() + "]"));
            if (a.equals(coveringAnnotation) || BlueCasUtil.isDocAnnot(a)) continue;
            list.add((Annotation)a);
        }
        return Collections.unmodifiableList(list);
    }

    public static boolean keepDoc(JCas jCas) {
        String lang = jCas.getDocumentLanguage();
        if (lang.equals("x-unspecified")) {
            LOG.warn("document language needed to decide whether to keepDoc(), but document language is not set, pmId" + BlueCasUtil.getHeaderDocId(jCas));
        }
        return (lang.equals("en") || lang.equals("x-unspecified")) && !JCasUtil.exists((JCas)jCas, TooFewTokensPerPage.class) && !JCasUtil.exists((JCas)jCas, TooManyOOV.class);
    }

    public static <T extends TOP> List<T> asList(Iterable<T> select) {
        return Lists.newLinkedList(select);
    }

    public static boolean isDocAnnot(AnnotationFS a) {
        return a.getType().getName().equals("uima.tcas.DocumentAnnotation");
    }

    public static int distance(Annotation a1, Annotation a2) {
        int dist = a2.getBegin() - a1.getEnd();
        if (dist > 0) {
            return dist;
        }
        dist = a1.getBegin() - a2.getEnd();
        if (dist > 0) {
            return dist;
        }
        return -1;
    }

    public static int maxEnd(Annotation a1, Annotation a2) {
        return Math.max(a1.getEnd(), a2.getEnd());
    }

    public static int minBegin(Annotation a1, Annotation a2) {
        return Math.min(a1.getBegin(), a2.getBegin());
    }

    public static Position isBefore(Annotation a1, Annotation a2) {
        if (a2.getBegin() - a1.getEnd() > 0) {
            return Position.before;
        }
        if (a1.getBegin() - a2.getEnd() > 0) {
            return Position.after;
        }
        return Position.overlap;
    }

    public static boolean isContained(Annotation a1, Annotation a2) {
        return a1.getBegin() >= a2.getBegin() && a1.getEnd() <= a2.getEnd();
    }

    public static List<String> toList(StringArray tokens) {
        ArrayList<String> l = new ArrayList<String>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            l.add(tokens.get(i));
        }
        return l;
    }

    public static enum Position {
        before,
        after,
        overlap;

    }
}

