/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.shaded;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestShadedHBaseTestingUtility {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShadedHBaseTestingUtility.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreateTable() throws Exception {
        TableName tableName = TableName.valueOf((String)"test");
        Table table = TEST_UTIL.createTable(tableName, "cf");
        Put put1 = new Put(Bytes.toBytes((String)"r1"));
        put1.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"c"), Bytes.toBytes((int)1));
        table.put(put1);
        Put put2 = new Put(Bytes.toBytes((String)"r2"));
        put2.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"c"), Bytes.toBytes((int)2));
        table.put(put2);
        int rows = TEST_UTIL.countRows(tableName);
        Assert.assertEquals((long)2L, (long)rows);
    }
}

