/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.os.Build;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.acra.security.TLS;

public class ProtocolSocketFactoryWrapper
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final List<String> protocols;

    public ProtocolSocketFactoryWrapper(SSLSocketFactory delegate, List<TLS> protocols) {
        this.delegate = delegate;
        ArrayList<TLS> list = new ArrayList<TLS>(protocols);
        if (Build.VERSION.SDK_INT < 29) {
            list.remove((Object)TLS.V1_3);
            if (Build.VERSION.SDK_INT < 16) {
                list.remove((Object)TLS.V1_2);
                list.remove((Object)TLS.V1_1);
            }
        }
        this.protocols = new ArrayList<String>(list.size());
        for (TLS tls : list) {
            this.protocols.add(tls.getId());
        }
    }

    private Socket setProtocols(Socket socket) {
        if (socket instanceof SSLSocket && this.isTLSServerEnabled((SSLSocket)socket)) {
            ((SSLSocket)socket).setEnabledProtocols(this.protocols.toArray(new String[0]));
        }
        return socket;
    }

    private boolean isTLSServerEnabled(SSLSocket sslSocket) {
        for (String protocol : sslSocket.getSupportedProtocols()) {
            if (!this.protocols.contains(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return this.setProtocols(this.delegate.createSocket(socket, s, i, b));
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        return this.setProtocols(this.delegate.createSocket(s, i));
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        return this.setProtocols(this.delegate.createSocket(s, i, inetAddress, i1));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.setProtocols(this.delegate.createSocket(inetAddress, i));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.setProtocols(this.delegate.createSocket(inetAddress, i, inetAddress1, i1));
    }
}

