/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.content.Context;
import androidx.annotation.NonNull;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.acra.ACRA;
import org.acra.security.BaseKeyStoreFactory;

final class FileKeyStoreFactory
extends BaseKeyStoreFactory {
    private final String filePath;

    FileKeyStoreFactory(String certificateType, String filePath) {
        super(certificateType);
        this.filePath = filePath;
    }

    @Override
    public InputStream getInputStream(@NonNull Context context) {
        try {
            return new FileInputStream(this.filePath);
        }
        catch (FileNotFoundException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Could not find File " + this.filePath, (Throwable)e);
            return null;
        }
    }
}

