/*
 * Decompiled with CFR 0.152.
 */
package org.acra.http;

import android.content.Context;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.http.BaseHttpRequest;
import org.acra.sender.HttpSender;
import org.acra.util.UriUtils;

public class MultipartHttpRequest
extends BaseHttpRequest<Pair<String, List<Uri>>> {
    private static final String BOUNDARY = "%&ACRA_REPORT_DIVIDER&%";
    private static final String BOUNDARY_FIX = "--";
    private static final String NEW_LINE = "\r\n";
    private static final String SECTION_START = "\r\n--%&ACRA_REPORT_DIVIDER&%\r\n";
    private static final String MESSAGE_END = "\r\n--%&ACRA_REPORT_DIVIDER&%--\r\n";
    private static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n";
    private static final String CONTENT_TYPE = "Content-Type: %s\r\n";
    private final Context context;
    private final String contentType;

    public MultipartHttpRequest(@NonNull CoreConfiguration config, @NonNull Context context, @NonNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers) {
        super(config, context, HttpSender.Method.POST, login, password, connectionTimeOut, socketTimeOut, headers);
        this.context = context;
        this.contentType = contentType;
    }

    @Override
    @NonNull
    protected String getContentType(@NonNull Context context, @NonNull Pair<String, List<Uri>> stringListPair) {
        return "multipart/form-data; boundary=%&ACRA_REPORT_DIVIDER&%";
    }

    @Override
    protected void write(OutputStream outputStream, @NonNull Pair<String, List<Uri>> content) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        writer.append(SECTION_START).format(CONTENT_DISPOSITION, "ACRA_REPORT", "").format(CONTENT_TYPE, this.contentType).append(NEW_LINE).append((CharSequence)content.first);
        for (Uri uri : (List)content.second) {
            try {
                String name = UriUtils.getFileNameFromUri(this.context, uri);
                writer.append(SECTION_START).format(CONTENT_DISPOSITION, "ACRA_ATTACHMENT", name).format(CONTENT_TYPE, UriUtils.getMimeType(this.context, uri)).append(NEW_LINE).flush();
                UriUtils.copyFromUri(this.context, outputStream, uri);
            }
            catch (FileNotFoundException e) {
                ACRA.log.w("Not sending attachment", (Throwable)e);
            }
        }
        writer.append(MESSAGE_END).flush();
    }
}

