/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RawRes;
import java.util.Map;
import org.acra.annotation.AcraHttpSender;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.BaseHttpConfigurationBuilder;
import org.acra.config.HttpSenderConfiguration;
import org.acra.config.HttpSenderConfigurationBuilder;
import org.acra.security.KeyStoreFactory;
import org.acra.security.NoKeyStoreFactory;
import org.acra.security.TLS;
import org.acra.sender.HttpSender;

final class HttpSenderConfigurationBuilderImpl
implements HttpSenderConfigurationBuilder {
    @NonNull
    private final Context context;
    private boolean enabled;
    @NonNull
    private String uri;
    @NonNull
    private String basicAuthLogin;
    @NonNull
    private String basicAuthPassword;
    @NonNull
    private HttpSender.Method httpMethod;
    private int connectionTimeout;
    private int socketTimeout;
    private boolean dropReportsOnTimeout;
    @NonNull
    private Class<? extends KeyStoreFactory> keyStoreFactoryClass;
    @NonNull
    private String certificatePath;
    @RawRes
    private int resCertificate;
    @NonNull
    private String certificateType;
    private boolean compress;
    @NonNull
    private TLS[] tlsProtocols;
    @NonNull
    private final BaseHttpConfigurationBuilder delegate;

    HttpSenderConfigurationBuilderImpl(@NonNull Context arg0) {
        AcraHttpSender annotation = arg0.getClass().getAnnotation(AcraHttpSender.class);
        this.context = arg0;
        this.enabled = annotation != null;
        this.delegate = new BaseHttpConfigurationBuilder();
        if (this.enabled) {
            this.uri = annotation.uri();
            this.basicAuthLogin = annotation.basicAuthLogin();
            this.basicAuthPassword = annotation.basicAuthPassword();
            this.httpMethod = annotation.httpMethod();
            this.connectionTimeout = annotation.connectionTimeout();
            this.socketTimeout = annotation.socketTimeout();
            this.dropReportsOnTimeout = annotation.dropReportsOnTimeout();
            this.keyStoreFactoryClass = annotation.keyStoreFactoryClass();
            this.certificatePath = annotation.certificatePath();
            this.resCertificate = annotation.resCertificate();
            this.certificateType = annotation.certificateType();
            this.compress = annotation.compress();
            this.tlsProtocols = annotation.tlsProtocols();
        } else {
            this.basicAuthLogin = "ACRA-NULL-STRING";
            this.basicAuthPassword = "ACRA-NULL-STRING";
            this.connectionTimeout = 5000;
            this.socketTimeout = 20000;
            this.dropReportsOnTimeout = false;
            this.keyStoreFactoryClass = NoKeyStoreFactory.class;
            this.certificatePath = "";
            this.resCertificate = 0;
            this.certificateType = "X.509";
            this.compress = false;
            this.tlsProtocols = new TLS[]{TLS.V1_3, TLS.V1_2, TLS.V1_1, TLS.V1};
        }
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    boolean enabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setUri(@NonNull String uri) {
        this.uri = uri;
        return this;
    }

    @NonNull
    String uri() {
        return this.uri;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setBasicAuthLogin(@NonNull String basicAuthLogin) {
        this.basicAuthLogin = basicAuthLogin;
        return this;
    }

    @NonNull
    String basicAuthLogin() {
        return this.basicAuthLogin;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setBasicAuthPassword(@NonNull String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
        return this;
    }

    @NonNull
    String basicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setHttpMethod(@NonNull HttpSender.Method httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @NonNull
    HttpSender.Method httpMethod() {
        return this.httpMethod;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    int connectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    int socketTimeout() {
        return this.socketTimeout;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setDropReportsOnTimeout(boolean dropReportsOnTimeout) {
        this.dropReportsOnTimeout = dropReportsOnTimeout;
        return this;
    }

    boolean dropReportsOnTimeout() {
        return this.dropReportsOnTimeout;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setKeyStoreFactoryClass(@NonNull Class<? extends KeyStoreFactory> keyStoreFactoryClass) {
        this.keyStoreFactoryClass = keyStoreFactoryClass;
        return this;
    }

    @NonNull
    Class<? extends KeyStoreFactory> keyStoreFactoryClass() {
        return this.keyStoreFactoryClass;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setCertificatePath(@NonNull String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    @NonNull
    String certificatePath() {
        return this.certificatePath;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setResCertificate(@RawRes int resCertificate) {
        this.resCertificate = resCertificate;
        return this;
    }

    @RawRes
    int resCertificate() {
        return this.resCertificate;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setCertificateType(@NonNull String certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    @NonNull
    String certificateType() {
        return this.certificateType;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setCompress(boolean compress) {
        this.compress = compress;
        return this;
    }

    boolean compress() {
        return this.compress;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setTlsProtocols(TLS ... tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
        return this;
    }

    @NonNull
    TLS[] tlsProtocols() {
        return this.tlsProtocols;
    }

    @Override
    @NonNull
    public HttpSenderConfigurationBuilderImpl setHttpHeaders(Map<String, String> headers) {
        this.delegate.setHttpHeaders(headers);
        return this;
    }

    @NonNull
    Map<String, String> httpHeaders() {
        return this.delegate.httpHeaders();
    }

    @NonNull
    public HttpSenderConfiguration build() throws ACRAConfigurationException {
        if (this.enabled) {
            if (this.uri == null) {
                throw new ACRAConfigurationException("uri has to be set");
            }
            if (this.httpMethod == null) {
                throw new ACRAConfigurationException("httpMethod has to be set");
            }
        }
        return new HttpSenderConfiguration(this);
    }
}

