/*
 * Decompiled with CFR 0.152.
 */
package org.acra.annotation;

import androidx.annotation.NonNull;
import androidx.annotation.RawRes;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.acra.security.KeyStoreFactory;
import org.acra.security.NoKeyStoreFactory;
import org.acra.security.TLS;
import org.acra.sender.HttpSender;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Inherited
public @interface AcraHttpSender {
    @NonNull
    public String uri();

    @NonNull
    public String basicAuthLogin() default "ACRA-NULL-STRING";

    @NonNull
    public String basicAuthPassword() default "ACRA-NULL-STRING";

    @NonNull
    public HttpSender.Method httpMethod();

    public int connectionTimeout() default 5000;

    public int socketTimeout() default 20000;

    public boolean dropReportsOnTimeout() default false;

    @NonNull
    public Class<? extends KeyStoreFactory> keyStoreFactoryClass() default NoKeyStoreFactory.class;

    @NonNull
    public String certificatePath() default "";

    @RawRes
    public int resCertificate() default 0;

    @NonNull
    public String certificateType() default "X.509";

    public boolean compress() default false;

    @NonNull
    public TLS[] tlsProtocols() default {TLS.V1_3, TLS.V1_2, TLS.V1_1, TLS.V1};
}

