/*
 * Decompiled with CFR 0.152.
 */
package org.acra.file;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/acra/file/Directory;", "", "(Ljava/lang/String;I)V", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "FILES_LEGACY", "FILES", "EXTERNAL_FILES", "CACHE", "EXTERNAL_CACHE", "NO_BACKUP_FILES", "EXTERNAL_STORAGE", "ROOT", "acra-core_release"})
public abstract class Directory
extends Enum<Directory> {
    public static final /* enum */ Directory FILES_LEGACY;
    public static final /* enum */ Directory FILES;
    public static final /* enum */ Directory EXTERNAL_FILES;
    public static final /* enum */ Directory CACHE;
    public static final /* enum */ Directory EXTERNAL_CACHE;
    public static final /* enum */ Directory NO_BACKUP_FILES;
    public static final /* enum */ Directory EXTERNAL_STORAGE;
    public static final /* enum */ Directory ROOT;
    private static final /* synthetic */ Directory[] $VALUES;

    static {
        Directory[] directoryArray = new Directory[8];
        Directory[] directoryArray2 = directoryArray;
        directoryArray[0] = FILES_LEGACY = new FILES_LEGACY("FILES_LEGACY", 0);
        directoryArray[1] = FILES = new FILES("FILES", 1);
        directoryArray[2] = EXTERNAL_FILES = new EXTERNAL_FILES("EXTERNAL_FILES", 2);
        directoryArray[3] = CACHE = new CACHE("CACHE", 3);
        directoryArray[4] = EXTERNAL_CACHE = new EXTERNAL_CACHE("EXTERNAL_CACHE", 4);
        directoryArray[5] = NO_BACKUP_FILES = new NO_BACKUP_FILES("NO_BACKUP_FILES", 5);
        directoryArray[6] = EXTERNAL_STORAGE = new EXTERNAL_STORAGE("EXTERNAL_STORAGE", 6);
        directoryArray[7] = ROOT = new ROOT("ROOT", 7);
        $VALUES = directoryArray;
    }

    @NotNull
    public abstract File getFile(@NotNull Context var1, @NotNull String var2);

    private Directory() {
    }

    public /* synthetic */ Directory(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static Directory[] values() {
        return (Directory[])$VALUES.clone();
    }

    public static Directory valueOf(String string) {
        return Enum.valueOf(Directory.class, string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$FILES_LEGACY;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class FILES_LEGACY
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return (StringsKt.startsWith$default((String)fileName, (String)"/", (boolean)false, (int)2, null) ? ROOT : FILES).getFile(context, fileName);
        }

        /*
         * WARNING - void declaration
         */
        FILES_LEGACY() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$FILES;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class FILES
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new File(context.getFilesDir(), fileName);
        }

        /*
         * WARNING - void declaration
         */
        FILES() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$EXTERNAL_FILES;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class EXTERNAL_FILES
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new File(context.getExternalFilesDir(null), fileName);
        }

        /*
         * WARNING - void declaration
         */
        EXTERNAL_FILES() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$CACHE;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class CACHE
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new File(context.getCacheDir(), fileName);
        }

        /*
         * WARNING - void declaration
         */
        CACHE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$EXTERNAL_CACHE;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class EXTERNAL_CACHE
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new File(context.getExternalCacheDir(), fileName);
        }

        /*
         * WARNING - void declaration
         */
        EXTERNAL_CACHE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$NO_BACKUP_FILES;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class NO_BACKUP_FILES
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            File file;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            if (Build.VERSION.SDK_INT >= 21) {
                File file2 = context.getNoBackupFilesDir();
                file = file2;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.noBackupFilesDir");
            } else {
                file = new File(context.getApplicationInfo().dataDir, "no_backup");
            }
            File dir = file;
            return new File(dir, fileName);
        }

        /*
         * WARNING - void declaration
         */
        NO_BACKUP_FILES() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$EXTERNAL_STORAGE;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class EXTERNAL_STORAGE
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new File(Environment.getExternalStorageDirectory(), fileName);
        }

        /*
         * WARNING - void declaration
         */
        EXTERNAL_STORAGE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/file/Directory$ROOT;", "Lorg/acra/file/Directory;", "getFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "fileName", "", "acra-core_release"})
    static final class ROOT
    extends Directory {
        @Override
        @NotNull
        public File getFile(@NotNull Context context, @NotNull String fileName) {
            File[] roots;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            CharSequence charSequence = fileName;
            String[] stringArray = new String[1];
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.separator");
            stringArray[0] = string;
            List parts = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            if (parts.size() == 1) {
                return new File(fileName);
            }
            for (File root : roots = File.listRoots()) {
                String string2 = (String)parts.get(0);
                File file = root;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root");
                String string3 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"root.path");
                String string4 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"File.separator");
                if (!Intrinsics.areEqual((Object)string2, (Object)StringsKt.replace$default((String)string3, (String)string4, (String)"", (boolean)false, (int)4, null))) continue;
                return new File(root, (String)parts.get(1));
            }
            return new File(roots[0], fileName);
        }

        /*
         * WARNING - void declaration
         */
        ROOT() {
            void var1_1;
        }
    }
}

