/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.SharedPreferencesCollector$WhenMappings;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\u0003\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/acra/collector/SharedPreferencesCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "collect", "Lorg/json/JSONObject;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "", "reportField", "Lorg/acra/ReportField;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "filteredKey", "", "key", "", "acra-core_release"})
public final class SharedPreferencesCollector
extends BaseReportFieldCollector {
    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (SharedPreferencesCollector$WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.USER_EMAIL, new SharedPreferencesFactory(context, config).create().getString("acra.user.email", null));
                break;
            }
            case 2: {
                target.put(ReportField.SHARED_PREFERENCES, this.collect(context, config));
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject collect(Context context, CoreConfiguration config) throws JSONException {
        JSONObject result = new JSONObject();
        Map sharedPrefs = new TreeMap();
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"PreferenceManager.getDef\u2026haredPreferences(context)");
        sharedPrefs.put("default", sharedPreferences);
        for (String sharedPrefId : config.getAdditionalSharedPreferences()) {
            SharedPreferences sharedPreferences2 = context.getSharedPreferences(sharedPrefId, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences2, (String)"context.getSharedPrefere\u2026Id, Context.MODE_PRIVATE)");
            sharedPrefs.put(sharedPrefId, sharedPreferences2);
        }
        Object object = sharedPrefs;
        int n = 0;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void sharedPrefId;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl = false;
            SharedPreferences prefs = (SharedPreferences)entry2.getValue();
            Map prefEntries = prefs.getAll();
            if (prefEntries.isEmpty()) {
                result.put((String)sharedPrefId, (Object)"empty");
                continue;
            }
            Iterator iterator2 = prefEntries.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(k, (String)"iterator.next()");
                if (!this.filteredKey(config, (String)k)) continue;
                iterator2.remove();
            }
            result.put((String)sharedPrefId, (Object)new JSONObject(prefEntries));
        }
        return result;
    }

    private final boolean filteredKey(CoreConfiguration config, String key) {
        for (String regex : config.getExcludeMatchingSharedPreferencesKeys()) {
            CharSequence charSequence = key;
            Regex regex2 = new Regex(regex);
            boolean bl = false;
            if (!regex2.matches(charSequence)) continue;
            return true;
        }
        return false;
    }

    public SharedPreferencesCollector() {
        super(ReportField.USER_EMAIL, ReportField.SHARED_PREFERENCES);
    }
}

