/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.collector.MediaCodecListCollector$WhenMappings;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0003J\b\u0010\"\u001a\u00020\u001eH\u0003J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020 H\u0003J\b\u0010%\u001a\u00020\u0012H\u0002J(\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/acra/collector/MediaCodecListCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "mAACProfileValues", "Landroid/util/SparseArray;", "", "mAVCLevelValues", "mAVCProfileValues", "mColorFormatValues", "mH263LevelValues", "mH263ProfileValues", "mMPEG4LevelValues", "mMPEG4ProfileValues", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectCapabilitiesForType", "Lorg/json/JSONObject;", "codecInfo", "Landroid/media/MediaCodecInfo;", "type", "collectMediaCodecList", "identifyCodecType", "Lorg/acra/collector/MediaCodecListCollector$CodecType;", "prepare", "shouldCollect", "", "CodecType", "Companion", "acra-core_release"})
public final class MediaCodecListCollector
extends BaseReportFieldCollector {
    private final SparseArray<String> mColorFormatValues = new SparseArray();
    private final SparseArray<String> mAVCLevelValues = new SparseArray();
    private final SparseArray<String> mAVCProfileValues = new SparseArray();
    private final SparseArray<String> mH263LevelValues = new SparseArray();
    private final SparseArray<String> mH263ProfileValues = new SparseArray();
    private final SparseArray<String> mMPEG4LevelValues = new SparseArray();
    private final SparseArray<String> mMPEG4ProfileValues = new SparseArray();
    private final SparseArray<String> mAACProfileValues = new SparseArray();
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    private static final String[] MPEG4_TYPES;
    private static final String[] AVC_TYPES;
    private static final String[] H263_TYPES;
    private static final String[] AAC_TYPES;
    public static final Companion Companion;

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.put(ReportField.MEDIA_CODEC_LIST, this.collectMediaCodecList());
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)collect, (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && Build.VERSION.SDK_INT >= 16;
    }

    private final void prepare() {
        try {
            Class<?> codecProfileLevelClass;
            Class<?> codecCapabilitiesClass;
            Class<?> clazz = codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"codecCapabilitiesClass");
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field f;
                Field field = f = fieldArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"f");
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                if (!StringsKt.startsWith$default((String)string, (String)COLOR_FORMAT_PREFIX, (boolean)false, (int)2, null)) continue;
                this.mColorFormatValues.put(f.getInt(null), (Object)f.getName());
            }
            Class<?> clazz2 = codecProfileLevelClass = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"codecProfileLevelClass");
            Field[] fieldArray2 = clazz2.getFields();
            int n2 = fieldArray2.length;
            for (int i = 0; i < n2; ++i) {
                Field f;
                Field field = f = fieldArray2[i];
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"f");
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                if (StringsKt.startsWith$default((String)string, (String)"AVCLevel", (boolean)false, (int)2, null)) {
                    this.mAVCLevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string2 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"f.name");
                if (StringsKt.startsWith$default((String)string2, (String)"AVCProfile", (boolean)false, (int)2, null)) {
                    this.mAVCProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string3 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"f.name");
                if (StringsKt.startsWith$default((String)string3, (String)"H263Level", (boolean)false, (int)2, null)) {
                    this.mH263LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string4 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"f.name");
                if (StringsKt.startsWith$default((String)string4, (String)"H263Profile", (boolean)false, (int)2, null)) {
                    this.mH263ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string5 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"f.name");
                if (StringsKt.startsWith$default((String)string5, (String)"MPEG4Level", (boolean)false, (int)2, null)) {
                    this.mMPEG4LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string6 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"f.name");
                if (StringsKt.startsWith$default((String)string6, (String)"MPEG4Profile", (boolean)false, (int)2, null)) {
                    this.mMPEG4ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string7 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"f.name");
                if (!StringsKt.startsWith$default((String)string7, (String)"AAC", (boolean)false, (int)2, null)) continue;
                this.mAACProfileValues.put(f.getInt(null), (Object)f.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=16)
    private final JSONObject collectMediaCodecList() throws JSONException {
        int codecIdx;
        int n;
        this.prepare();
        MediaCodecInfo[] infos = null;
        if (Build.VERSION.SDK_INT < 21) {
            int codecCount = MediaCodecList.getCodecCount();
            infos = new MediaCodecInfo[codecCount];
            int n2 = 0;
            n = codecCount;
            while (n2 < n) {
                infos[codecIdx] = MediaCodecList.getCodecInfoAt((int)codecIdx);
                ++codecIdx;
            }
        } else {
            MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(1).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"MediaCodecList(MediaCode\u2026st.ALL_CODECS).codecInfos");
            infos = mediaCodecInfoArray;
        }
        JSONObject result = new JSONObject();
        codecIdx = 0;
        n = infos.length;
        while (codecIdx < n) {
            void i;
            MediaCodecInfo codecInfo = infos[i];
            JSONObject codec = new JSONObject();
            MediaCodecInfo mediaCodecInfo = codecInfo;
            Intrinsics.checkNotNull((Object)mediaCodecInfo);
            String[] supportedTypes = mediaCodecInfo.getSupportedTypes();
            codec.put("name", (Object)codecInfo.getName()).put("isEncoder", codecInfo.isEncoder());
            JSONObject supportedTypesJson = new JSONObject();
            String[] stringArray = supportedTypes;
            int n3 = stringArray.length;
            for (int j = 0; j < n3; ++j) {
                String type;
                String string = type = stringArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type");
                supportedTypesJson.put(type, (Object)this.collectCapabilitiesForType(codecInfo, string));
            }
            codec.put("supportedTypes", (Object)supportedTypesJson);
            result.put(String.valueOf((int)i), (Object)codec);
            ++i;
        }
        return result;
    }

    @TargetApi(value=16)
    private final JSONObject collectCapabilitiesForType(MediaCodecInfo codecInfo, String type) throws JSONException {
        JSONObject result = new JSONObject();
        MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
        int[] colorFormats = codecCapabilities.colorFormats;
        Intrinsics.checkNotNullExpressionValue((Object)colorFormats, (String)"colorFormats");
        int[] nArray = colorFormats;
        boolean bl = false;
        Object[] objectArray = nArray;
        boolean bl2 = false;
        if (!(objectArray.length == 0)) {
            JSONArray colorFormatsJson = new JSONArray();
            for (int colorFormat : colorFormats) {
                colorFormatsJson.put(this.mColorFormatValues.get(colorFormat));
            }
            result.put("colorFormats", (Object)colorFormatsJson);
        }
        CodecType codecType = this.identifyCodecType(codecInfo);
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevels = codecCapabilities.profileLevels;
        Intrinsics.checkNotNullExpressionValue((Object)codecProfileLevels, (String)"codecProfileLevels");
        objectArray = codecProfileLevels;
        bl2 = false;
        Object[] objectArray2 = objectArray;
        boolean bl3 = false;
        if (!(objectArray2.length == 0)) {
            JSONArray profileLevels = new JSONArray();
            block7: for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecProfileLevels) {
                int profileValue = codecProfileLevel.profile;
                int levelValue = codecProfileLevel.level;
                if (codecType == null) {
                    profileLevels.put(profileValue + 45 + levelValue);
                    break;
                }
                switch (MediaCodecListCollector$WhenMappings.$EnumSwitchMapping$0[codecType.ordinal()]) {
                    case 1: {
                        profileLevels.put((Object)(profileValue + (String)this.mAVCProfileValues.get(profileValue) + '-' + (String)this.mAVCLevelValues.get(levelValue)));
                        continue block7;
                    }
                    case 2: {
                        profileLevels.put((Object)((String)this.mH263ProfileValues.get(profileValue) + '-' + (String)this.mH263LevelValues.get(levelValue)));
                        continue block7;
                    }
                    case 3: {
                        profileLevels.put((Object)((String)this.mMPEG4ProfileValues.get(profileValue) + '-' + (String)this.mMPEG4LevelValues.get(levelValue)));
                        continue block7;
                    }
                    case 4: {
                        profileLevels.put(this.mAACProfileValues.get(profileValue));
                        continue block7;
                    }
                }
            }
            result.put("profileLevels", (Object)profileLevels);
        }
        return result;
    }

    @TargetApi(value=16)
    private final CodecType identifyCodecType(MediaCodecInfo codecInfo) {
        String string = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codecInfo.name");
        String name = string;
        for (String token : AVC_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.AVC;
        }
        for (String token : H263_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.H263;
        }
        for (String token : MPEG4_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.MPEG4;
        }
        for (String token : AAC_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.AAC;
        }
        return null;
    }

    public MediaCodecListCollector() {
        super(ReportField.MEDIA_CODEC_LIST);
    }

    static {
        Companion = new Companion(null);
        MPEG4_TYPES = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
        AVC_TYPES = new String[]{"avc", "h264", "AVC", "H264"};
        H263_TYPES = new String[]{"h263", "H263"};
        AAC_TYPES = new String[]{"aac", "AAC"};
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/acra/collector/MediaCodecListCollector$CodecType;", "", "(Ljava/lang/String;I)V", "AVC", "H263", "MPEG4", "AAC", "acra-core_release"})
    private static final class CodecType
    extends Enum<CodecType> {
        public static final /* enum */ CodecType AVC;
        public static final /* enum */ CodecType H263;
        public static final /* enum */ CodecType MPEG4;
        public static final /* enum */ CodecType AAC;
        private static final /* synthetic */ CodecType[] $VALUES;

        static {
            CodecType[] codecTypeArray = new CodecType[4];
            CodecType[] codecTypeArray2 = codecTypeArray;
            codecTypeArray[0] = AVC = new CodecType();
            codecTypeArray[1] = H263 = new CodecType();
            codecTypeArray[2] = MPEG4 = new CodecType();
            codecTypeArray[3] = AAC = new CodecType();
            $VALUES = codecTypeArray;
        }

        public static CodecType[] values() {
            return (CodecType[])$VALUES.clone();
        }

        public static CodecType valueOf(String string) {
            return Enum.valueOf(CodecType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/acra/collector/MediaCodecListCollector$Companion;", "", "()V", "AAC_TYPES", "", "", "[Ljava/lang/String;", "AVC_TYPES", "COLOR_FORMAT_PREFIX", "H263_TYPES", "MPEG4_TYPES", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

